/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.validation;

import java.sql.SQLException;
import java.util.HashMap;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.factories.BaseColumnFactory;
import org.gcube.data.analysis.tabulardata.model.metadata.table.HarmonizationRuleTable;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableType;
import org.gcube.data.analysis.tabulardata.model.table.type.GenericTableType;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;
import org.gcube.data.analysis.tabulardata.operation.utils.Harmonizations;
import org.gcube.data.analysis.tabulardata.operation.validation.ValidateDataWithExpressionFactory;
import org.gcube.data.analysis.tabulardata.operation.validation.ValidateDimensionColumnFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerWrapper;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.ValidityResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ValidationWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateDimensionWorker
extends ValidationWorker {
    private static Logger logger = LoggerFactory.getLogger(ValidateDimensionWorker.class);
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private SQLExpressionEvaluatorFactory sqlEvaluatorFactory;
    private ValidateDataWithExpressionFactory validatorFactory;
    private Table targetTable;
    private Column dimensionCandidate;
    private Table codelistTable;
    private Column referredColumn;
    private Table appTable = null;
    private Column appColumn = null;

    public ValidateDimensionWorker(OperationInvocation sourceInvocation, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, SQLExpressionEvaluatorFactory sqlEvaluatorFactory, ValidateDataWithExpressionFactory validatorFactory) {
        super(sourceInvocation);
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.sqlEvaluatorFactory = sqlEvaluatorFactory;
        this.validatorFactory = validatorFactory;
    }

    protected ValidityResult execute() throws WorkerException {
        this.init();
        this.updateProgress(0.1f, "Checking harmonization rules");
        this.evaluateExistingHarmonizationRules();
        this.updateProgress(0.6f, "Validating dimension candidate");
        ValidityResult toReturn = this.wrapValidation();
        this.updateProgress(0.9f, "Finalizing validation");
        if (this.appTable != null) {
            this.restoreHarmonizedValues();
            this.updateProgress(0.95f, "Cleaning up");
        }
        return toReturn;
    }

    private void evaluateExistingHarmonizationRules() throws WorkerException {
        try {
            logger.debug("target codelist is " + this.codelistTable);
            if (this.codelistTable.contains(HarmonizationRuleTable.class)) {
                HarmonizationRuleTable rules = (HarmonizationRuleTable)this.codelistTable.getMetadata(HarmonizationRuleTable.class);
                if (Harmonizations.isColumnUnderRules(this.referredColumn.getLocalId(), rules, this.connectionProvider, this.sqlEvaluatorFactory)) {
                    this.updateProgress(0.2f, "evaluating harmonization rules");
                    logger.debug("Preparing table with harmonizations");
                    this.prepareTable(rules);
                } else {
                    logger.debug("No rule defined for col " + this.referredColumn.getLocalId());
                }
            } else {
                logger.debug("Harmonization rules not found");
            }
        }
        catch (Exception e) {
            throw new WorkerException("Unable to evaluate Harmonizations", (Throwable)e);
        }
    }

    private void init() {
        this.targetTable = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
        this.dimensionCandidate = this.targetTable.getColumnById(this.getSourceInvocation().getTargetColumnId());
        ColumnReference ref = (ColumnReference)OperationHelper.getParameter((LeafParameter)ValidateDimensionColumnFactory.TARGET_COLUMN_PARAMETER, (OperationInvocation)this.getSourceInvocation());
        this.codelistTable = this.cubeManager.getTable(ref.getTableId());
        this.referredColumn = this.codelistTable.getColumnById(ref.getColumnId());
    }

    private void prepareTable(HarmonizationRuleTable harmTable) throws SQLException {
        this.appColumn = BaseColumnFactory.getFactory((ColumnType)this.dimensionCandidate.getColumnType()).create(this.dimensionCandidate.getDataType());
        this.appTable = this.cubeManager.createTable((TableType)new GenericTableType()).addColumn(this.appColumn).create();
        String copyStatement = String.format("INSERT INTO %s (id,%s) (SELECT id,%s from %s)", this.appTable.getName(), this.appColumn.getName(), this.dimensionCandidate.getName(), this.targetTable.getName());
        logger.debug("Copying values before applying harmonization");
        SQLHelper.executeSQLCommand((String)copyStatement, (DatabaseConnectionProvider)this.connectionProvider);
        logger.debug("Applying harmonizations..");
        Harmonizations.harmonizeTable(harmTable, (ColumnReference)this.codelistTable.getColumnReference(this.referredColumn), (ColumnReference)this.targetTable.getColumnReference(this.dimensionCandidate), this.targetTable, this.connectionProvider, this.sqlEvaluatorFactory);
    }

    private ValidityResult wrapValidation() throws WorkerException {
        try {
            WorkerWrapper wrapper = new WorkerWrapper((WorkerFactory)this.validatorFactory);
            HashMap<String, Object> map = new HashMap<String, Object>();
            Expression toCheck = ValidateDimensionColumnFactory.generateValidationExpression(this.getSourceInvocation());
            map.put(ValidateDataWithExpressionFactory.EXPRESSION_PARAMETER.getIdentifier(), toCheck);
            map.put(ValidateDataWithExpressionFactory.DESCRIPTION_PARAMETER.getIdentifier(), "External reference check");
            map.put(ValidateDataWithExpressionFactory.VALIDATION_CODE_PARAMETER.getIdentifier(), "104");
            wrapper.execute(this.targetTable.getId(), null, map);
            return (ValidityResult)wrapper.getResult();
        }
        catch (InvalidInvocationException e) {
            throw new WorkerException("Unable to wrap validator", (Throwable)e);
        }
    }

    private void restoreHarmonizedValues() throws WorkerException {
        String restoreCommand = "DO $$DECLARE r record; BEGIN FOR r in SELECT * FROM " + this.appTable.getName() + "  LOOP " + "   UPDATE " + this.targetTable.getName() + " SET " + this.dimensionCandidate.getName() + " = r." + this.appColumn.getName() + " WHERE " + this.targetTable.getName() + ".id = r.id;" + "   END LOOP;" + " END$$";
        try {
            SQLHelper.executeSQLCommand((String)restoreCommand, (DatabaseConnectionProvider)this.connectionProvider);
        }
        catch (SQLException e) {
            throw new WorkerException("Unable to restore data", (Throwable)e);
        }
    }
}

