package org.gcube.data.analysis.tabulardata.operation.time;

import javax.inject.Inject;
import javax.inject.Singleton;

import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.time.PeriodType;

@Singleton
public class MonthHelper implements PeriodTypeHelper {

	@Inject
	private CubeManager cubeManager;

	@Override
	public String getFillValidationColumnSQL(String validationTableName, String validationColumnName,
			String targetColumnName) {
		return String.format("UPDATE %s SET %s = false WHERE %s IS NULL OR NOT(is_valid_month(%s))", validationTableName, validationColumnName,
				targetColumnName, targetColumnName);
	}

	@Override
	public PeriodType getManagedPeriodType() {
		return PeriodType.MONTH;
	}

	@Override
	public Table createTimeCodelist() {
		return cubeManager.createTimeCodelist(PeriodType.MONTH);
	}

	
	
	@Override
	public String getColumnName() {
		return "month_code";
	}

	@Override
	public String getFillTimeCodelistSQL(String targetTableName, String targetColumnName, String timeTableName) {
		return String.format("INSERT INTO %s ( month_code ) SELECT DISTINCT(normalize_month(%s)) FROM %s;", timeTableName, 
				targetColumnName, targetTableName);
	}

	
	
	@Override
	public String getUpdateDimensionColumnSQL(String targetColumnName, String newTableName,
			String timeDimensionColumnName, String timeTableName) {
		
		return String
				.format("UPDATE %1$s AS new_table SET %2$s = refCol.id FROM (SELECT id,  month_code as val FROM %3$s) as refCol"
						+ " WHERE refCol.val=normalize_month(new_table.%4$s) ;",
						newTableName, timeDimensionColumnName, timeTableName,
						targetColumnName);
	
	}

}
