package org.gcube.data.analysis.tabulardata.operation.datatype;

import java.util.List;

import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;

public class TextToDateSQLHandler extends TypeTransitionSQLHandler {

	@Override
	public String getCopyDataSQLCommand(Table newTable, Table targetTable, Column targetColumn) {
		StringBuilder sqlBuilder = new StringBuilder();
		List<Column> columnsToCopy = newTable.getColumns();
		String columnNamesSnippet = SQLHelper.generateColumnNameSnippet(columnsToCopy);
		sqlBuilder.append(String.format("INSERT INTO %s (%s) ", newTable.getName(), columnNamesSnippet));
		columnNamesSnippet = generateTypedColumnNameSnippet(newTable, targetColumn);
		sqlBuilder.append(String.format("SELECT %s FROM %s;", columnNamesSnippet, targetTable.getName()));
		return sqlBuilder.toString();
	}
	
	private String generateTypedColumnNameSnippet(Table newTable, Column targetColumn) {
		StringBuilder sb = new StringBuilder();
		for (Column column : newTable.getColumns()) {
			if (column.getName().equals(targetColumn.getName())) {
				sb.append(String.format("CAST(%s AS date)", column.getName()));
			} else
				sb.append(column.getName());
			sb.append(", ");
		}
		sb.delete(sb.length() - 2, sb.length() - 1);
		return sb.toString();
	}

	@Override
	public String getConditionForInvalidEntry(Column targetColumn) {
		return String.format("NOT(is_valid_date(%s))",targetColumn.getName());
	}
	
}
