package org.gcube.data.analysis.tabulardata.operation.column;

import java.util.ArrayList;
import java.util.List;

import javax.inject.Singleton;

import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AnnotationColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AttributeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeDescriptionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeNameColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.MeasureColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.validation.ColumnTypeCastValidatorFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;

import com.google.common.collect.Lists;

@Singleton
public abstract class SimpleTextTypedColumnTypeTransformationFactory extends ChangeColumnTypeTransformationFactory {

	public final static List<ColumnType> allowedSourceColumnTypes = Lists.newArrayList();

	private static final List<Parameter> parameters=new ArrayList<>();
	
	static {
		allowedSourceColumnTypes.add(new AnnotationColumnType());
		allowedSourceColumnTypes.add(new MeasureColumnType());
		allowedSourceColumnTypes.add(new AttributeColumnType());
		allowedSourceColumnTypes.add(new CodeColumnType());
		allowedSourceColumnTypes.add(new CodeNameColumnType());
		allowedSourceColumnTypes.add(new CodeDescriptionColumnType());
		
		parameters.add(ADDITIONAL_META_PARAMETER);
	}

	private DatabaseConnectionProvider connectionProvider;
	
	private CubeManager cubeManager;

	public SimpleTextTypedColumnTypeTransformationFactory(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider) {
		this.cubeManager = cubeManager;
		this.connectionProvider = connectionProvider;
	}

	@Override
	public Worker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
		performBaseChecks(invocation,cubeManager);
		checkAllowedColumnTypeTransition(invocation, cubeManager);
		invocation.getParameterInstances().put(ColumnTypeCastValidatorFactory.TARGET_TYPE_PARAMETER.getIdentifier(), new TextType() );
		return new SimpleTextTypedColumnTypeTransformation(invocation, cubeManager, connectionProvider, getManagedColumnType());
	}

	protected List<ColumnType> getAllowedSourceColumnTypes() {
		return allowedSourceColumnTypes;
	}

	@Override
	protected List<Parameter> getParameters() {
		return parameters;
	}
	

}
