package org.gcube.data.analysis.tabulardata.operation;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.composite.comparable.Equals;
import org.gcube.data.analysis.tabulardata.expression.evaluator.EvaluatorException;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDBoolean;
import org.gcube.data.analysis.tabulardata.model.metadata.Locales;
import org.gcube.data.analysis.tabulardata.model.metadata.column.DataValidationMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ValidationReferencesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.GlobalDataValidationReportMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationHelper {

	private static final Logger log = LoggerFactory.getLogger(ValidationHelper.class);

//	public static boolean evaluateValidationColumnValidity(DatabaseConnectionProvider connectionProvider,
//			String tablename, String validationColumnName) throws WorkerException {
//
//		Connection conn = null;
//		Statement stmt = null;
//		ResultSet rs = null;
//		try {
//			conn = connectionProvider.getConnection();
//			stmt = conn.createStatement();
//			String sqlQuery = generateGetValidationResultSQLQuery(tablename, validationColumnName);
//			log.debug("Executing query:" + sqlQuery);
//			rs = stmt.executeQuery(sqlQuery);
//			while (rs.next()) {
//				return rs.getBoolean(1);
//			}
//			throw new WorkerException("Unable to obtain validation result");
//		} catch (SQLException e) {
//			String msg = "Unable to query table";
//			log.error(msg, e);
//			throw new WorkerException(msg, e);
//		} finally {
//			DbUtils.closeQuietly(conn);
//			DbUtils.closeQuietly(stmt);
//			DbUtils.closeQuietly(rs);
//		}
//
//	};

//	private static String generateGetValidationResultSQLQuery(String tableName, String validationColumnName) {
//		return String.format("SELECT bool_and(%s) from %s;", validationColumnName, tableName);
//	}

	public static GlobalDataValidationReportMetadata createDataValidationReport(Column validationColumn){
		LocalizedText name=validationColumn.getMetadata(NamesMetadata.class).getTextWithLocale(Locales.getDefaultLocale());
		DataValidationMetadata dataMeta=validationColumn.getMetadata(DataValidationMetadata.class);
		return new GlobalDataValidationReportMetadata(dataMeta.getDescription(), name, dataMeta.getInvalidRowsCount(), validationColumn.getLocalId());
	}
	
	public static int getErrorCount(DatabaseConnectionProvider connectionProvider,Table targetTable,Column validationColumn,SQLExpressionEvaluatorFactory evaluatorFactory ) throws EvaluatorException, SQLException{
		return SQLHelper.getCount(connectionProvider, targetTable.getName(),
				evaluatorFactory.getEvaluator(new Equals(targetTable.getColumnReference(validationColumn), new TDBoolean(false))).evaluate());
	}
	
}
