/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.table;

import com.google.common.collect.Lists;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.factories.types.TableTransformationWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.table.CreateView;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;

@Singleton
public class CreateViewFactory
extends TableTransformationWorkerFactory {
    private static final OperationId OPERATION_ID = new OperationId(1003L);
    private static final List<Parameter> parameters = Lists.newArrayList();
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;

    @Inject
    public CreateViewFactory(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider) {
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
    }

    private void checkTargetTableEligibility(OperationInvocation invocation) throws InvalidInvocationException {
        Table table = this.cubeManager.getTable(invocation.getTargetTableId());
        if (!table.hasRelationships()) {
            throw new InvalidInvocationException(invocation, "Table has no relationship, a view is not needed");
        }
    }

    public Worker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        this.checkTargetTableEligibility(invocation);
        return new CreateView(this.cubeManager, this.connectionProvider, invocation);
    }

    protected String getOperationName() {
        return "Create dataset view";
    }

    protected String getOperationDescription() {
        return "Create a dataset materialized view with data from linked codelists";
    }

    protected OperationId getOperationId() {
        return OPERATION_ID;
    }

    protected List<Parameter> getParameters() {
        return parameters;
    }
}

