/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.table;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableType;
import org.gcube.data.analysis.tabulardata.model.table.type.CodelistTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.DatasetTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.GenericTableType;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.factories.types.TableTransformationWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.MultivaluedStringParameter;
import org.gcube.data.analysis.tabulardata.operation.table.ChangeTableType;
import org.gcube.data.analysis.tabulardata.operation.validation.ValidateTableFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ChangeTableTypeFactory
extends TableTransformationWorkerFactory {
    public static final String TABLE_TYPE_PARAMETER_ID = "tableType";
    private static final OperationId OPERATION_ID = new OperationId(1002L);
    private static final List<TableType> availableTableTypes = new ArrayList<TableType>();
    private static final Logger log = LoggerFactory.getLogger(ChangeTableTypeFactory.class);
    @Inject
    private CubeManager cubeManager;
    @Inject
    private ValidateTableFactory validationFactory;

    static {
        availableTableTypes.add((TableType)new GenericTableType());
        availableTableTypes.add((TableType)new DatasetTableType());
        availableTableTypes.add((TableType)new CodelistTableType());
    }

    public static List<String> getAdmittedValues() {
        ArrayList admittedValues = Lists.newArrayList();
        for (TableType availableTableType : availableTableTypes) {
            admittedValues.add(availableTableType.getName());
        }
        return admittedValues;
    }

    public Worker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        this.checkInvocation(invocation);
        Table targetTable = this.cubeManager.getTable(invocation.getTargetTableId());
        String targetTableTypeName = (String)invocation.getParameterInstances().get(TABLE_TYPE_PARAMETER_ID);
        TableType targetTableType = ChangeTableTypeFactory.getTableType(targetTableTypeName);
        return new ChangeTableType(invocation, this.cubeManager, targetTable, targetTableType);
    }

    public static TableType getTableType(String targetTableTypeName) {
        TableType targetTableType = null;
        for (TableType availableTableType : availableTableTypes) {
            if (!availableTableType.getName().equals(targetTableTypeName)) continue;
            targetTableType = availableTableType;
        }
        return targetTableType;
    }

    private void checkInvocation(OperationInvocation invocation) throws InvalidInvocationException {
        try {
            List<String> admittedValues = ChangeTableTypeFactory.getAdmittedValues();
            String tableTypeName = (String)invocation.getParameterInstances().get(TABLE_TYPE_PARAMETER_ID);
            if (!admittedValues.contains(tableTypeName)) {
                throw new InvalidInvocationException(invocation, "Provided value is not admitted: " + tableTypeName);
            }
        }
        catch (InvalidInvocationException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Invalid invocation caused by exception", (Throwable)e);
            throw new InvalidInvocationException(invocation, "Uncaught exception caused invocation check to fail", e);
        }
    }

    protected String getOperationName() {
        return "Change table type";
    }

    protected String getOperationDescription() {
        return "Modify the table type";
    }

    protected OperationId getOperationId() {
        return OPERATION_ID;
    }

    protected List<Parameter> getParameters() {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        List<String> admittedValues = ChangeTableTypeFactory.getAdmittedValues();
        MultivaluedStringParameter tableTypeParameter = new MultivaluedStringParameter(TABLE_TYPE_PARAMETER_ID, "Table Type", "Table type", Cardinality.ONE, admittedValues);
        parameters.add((Parameter)tableTypeParameter);
        return parameters;
    }

    public List<WorkerFactory> getPrecoditionValidations() {
        return Collections.singletonList(this.validationFactory);
    }
}

