package org.gcube.data.analysis.tabulardata.operation.column;

import java.sql.SQLException;

import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.factories.DimensionColumnFactory;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.gcube.data.analysis.tabulardata.model.relationship.ColumnRelationship;
import org.gcube.data.analysis.tabulardata.model.relationship.ImmutableColumnRelationship;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.validation.ValidateDimensionColumnFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;

import com.google.common.collect.Lists;

public class ChangeToDimensionColumn extends Worker {

	private CubeManager cubeManager;

	private DatabaseConnectionProvider connectionProvider;


	private Table targetTable;

	private Column targetColumn;

	private Table refTable;

	private Column refColumn;

	private Table newTable;

	private Column dimensionColumn;

	public ChangeToDimensionColumn(OperationInvocation sourceInvocation, CubeManager cubeManager,
			DatabaseConnectionProvider connectionProvider) {
		super(sourceInvocation);
		this.cubeManager = cubeManager;
		this.connectionProvider = connectionProvider;
	}

	@Override
	protected WorkerResult execute() throws WorkerException {
		retrieveParameters();
		updateProgress(0.1f);
		createNewTable();
		updateProgress(0.3f);
		fillNewTableWithData();
		return new ImmutableWorkerResult(newTable);
	}

	private void retrieveParameters() {
		targetTable = cubeManager.getTable(getSourceInvocation().getTargetTableId());
		targetColumn = targetTable.getColumnById(getSourceInvocation().getTargetColumnId());
		ColumnReference columnReferenceParam = OperationHelper.getParameter(
				ValidateDimensionColumnFactory.TARGET_COLUMN_PARAMETER, getSourceInvocation());
		refTable = cubeManager.getTable(columnReferenceParam.getTableId());
		refColumn = refTable.getColumnById(columnReferenceParam.getColumnId());
	}

	private void createNewTable() {
		ColumnRelationship relationship = new ImmutableColumnRelationship(refTable);
		dimensionColumn = new DimensionColumnFactory().create(relationship);
		if (targetColumn.contains(NamesMetadata.class))
				dimensionColumn.setMetadata(targetColumn.getMetadata(NamesMetadata.class));
		
		newTable = cubeManager.createTable(targetTable.getTableType())
				.like(targetTable, true, Lists.newArrayList(targetColumn)).addColumnAfter(dimensionColumn, targetColumn).create();
	}

	private void fillNewTableWithData() throws WorkerException {
		String sqlCommand = getFillDimensionColumnSQLCommand();
		try {
			SQLHelper.executeSQLCommand(sqlCommand, connectionProvider);
		} catch (SQLException e) {
			throw new WorkerException("Unable to create a reference for some data",e);
		}
	}

	private String getFillDimensionColumnSQLCommand() {
		return String
				.format("UPDATE %1$s AS new_table SET %2$s = refCol.id FROM (SELECT id, %5$s as val FROM %4$s) as refCol,"
						+ " %6$s as targetTable WHERE targetTable.id = new_table.id and refCol.val=targetTable.%3$s;",
						newTable.getName(), dimensionColumn.getName(), targetColumn.getName(), refTable.getName(),
						refColumn.getName(), targetTable.getName());
	
	}
	

}
