package org.gcube.data.analysis.tabulardata.operation;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import org.apache.commons.dbutils.DbUtils;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationHelper {

	private static final Logger log = LoggerFactory.getLogger(ValidationHelper.class);

	public static boolean evaluateValidationColumnValidity(DatabaseConnectionProvider connectionProvider,
			String tablename, String validationColumnName) throws WorkerException {

		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
		try {
			conn = connectionProvider.getConnection();
			stmt = conn.createStatement();
			String sqlQuery = generateGetValidationResultSQLQuery(tablename, validationColumnName);
			log.debug("Executing query:" + sqlQuery);
			rs = stmt.executeQuery(sqlQuery);
			while (rs.next()) {
				return rs.getBoolean(1);
			}
			throw new WorkerException("Unable to obtain validation result");
		} catch (SQLException e) {
			String msg = "Unable to query table";
			log.error(msg, e);
			throw new WorkerException(msg, e);
		} finally {
			DbUtils.closeQuietly(conn);
			DbUtils.closeQuietly(stmt);
			DbUtils.closeQuietly(rs);
		}

	};

	private static String generateGetValidationResultSQLQuery(String tableName, String validationColumnName) {
		return String.format("SELECT bool_and(%s) from %s;", validationColumnName, tableName);
	}

}
