package org.gcube.data.analysis.tabulardata.operation.datatype;

import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.datatype.BooleanType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.DateType;
import org.gcube.data.analysis.tabulardata.model.datatype.IntegerType;
import org.gcube.data.analysis.tabulardata.model.datatype.NumericType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;
import org.gcube.data.analysis.tabulardata.model.table.Table;

public abstract class TypeTransitionSQLHandler {

	public abstract String getCopyDataSQLCommand(Table newTable, Table targetTable, Column targetColumn);

	public static TypeTransitionSQLHandler getHandler(DataType sourceType, DataType newType) {
		if (sourceType.getClass().equals(newType.getClass()))
			return new SameTypeSQLHandler();
		if (sourceType instanceof TextType && newType instanceof IntegerType)
			return new TextToIntegerSQLHandler();
		if (sourceType instanceof TextType && newType instanceof NumericType)
			return new TextToNumericSQLHandler();
		if (newType instanceof TextType)
			return new AnyToTextSQLHandler();
		if (sourceType instanceof TextType) {
			if (newType instanceof BooleanType)
				return new TextToBooleanSQLHandler();
			if (newType instanceof DateType)
				return new TextToDateSQLHandler();
			if (newType instanceof IntegerType)
				return new TextToIntegerSQLHandler();
			if (newType instanceof NumericType)
				return new TextToNumericSQLHandler();
		}
		if (sourceType instanceof IntegerType && newType instanceof NumericType)
			return new IntegerToNumericSQLHandler();
		if (sourceType instanceof NumericType && newType instanceof IntegerType )
			return new NumericToIntegerSQLHandler();
		throw new UnsupportedOperationException(String.format("Transition from %s to %s is not supported", sourceType.getName(),
				newType.getName()));
	}

	public abstract String getFillValidationColumnSQLCommand(Table validationTable, Column validationColumn, Column targetColumn);
	
	public static boolean isSupportedTransition(DataType sourceType, DataType newType){
		try {
			getHandler(sourceType, newType);
			return true;
		} catch (UnsupportedOperationException e) {
			return false;
		}
		
	}

}
