package org.gcube.data.analysis.tabulardata.operation.column;

import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.operation.factories.types.ColumnTransformationWorkerFactory;

public abstract class ChangeColumnTypeTransformationFactory extends ColumnTransformationWorkerFactory {
	
	
	@Override
	protected String getOperationName() {
		return String.format("Change to %s column", getManagedColumnType().getName());
	}

	@Override
	protected String getOperationDescription() {
		return String.format("Change the column type to %1$s or modify a %1$s column", getManagedColumnType().getName());
	}

	protected abstract ColumnType getManagedColumnType();
	
}
