/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.column;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AnnotationColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AttributeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeDescriptionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeNameColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.DimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.MeasureColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.TimeDimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.column.ChangeColumnTypeTransformationFactory;
import org.gcube.data.analysis.tabulardata.operation.column.ChangeToAttributeColumn;
import org.gcube.data.analysis.tabulardata.operation.datatype.TypeTransitionSQLHandler;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.validation.ColumnTypeCastValidatorFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;

@Singleton
public class ChangeToAttributeColumnFactory
extends ChangeColumnTypeTransformationFactory {
    private static final AttributeColumnType MANAGED_COLUMN_TYPE = new AttributeColumnType();
    private static final OperationId OPERATION_ID = new OperationId(2001L);
    public static final List<Class<? extends ColumnType>> allowedSourceColumnTypes = Lists.newArrayList();
    private DatabaseConnectionProvider connectionProvider;
    private CubeManager cubeManager;
    private ColumnTypeCastValidatorFactory fallbackFactory;
    private static final List<Parameter> parameters = new ArrayList<Parameter>();

    @Inject
    public ChangeToAttributeColumnFactory(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, ColumnTypeCastValidatorFactory fallbackfactory) {
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.fallbackFactory = fallbackfactory;
    }

    @Override
    protected ColumnType getManagedColumnType() {
        return MANAGED_COLUMN_TYPE;
    }

    public Worker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.checkInvocation(invocation);
        this.checkTypeTransformationEligibility(invocation);
        return new ChangeToAttributeColumn(invocation, this.cubeManager, this.connectionProvider);
    }

    private void checkTypeTransformationEligibility(OperationInvocation invocation) throws InvalidInvocationException {
        DataType newDataType;
        Table targetTable = this.cubeManager.getTable(invocation.getTargetTableId());
        Column targetColumn = targetTable.getColumnById(invocation.getTargetColumnId());
        DataType sourceDataType = targetColumn.getDataType();
        if (TypeTransitionSQLHandler.isSupportedTransition(sourceDataType, newDataType = (DataType)OperationHelper.getParameter(ColumnTypeCastValidatorFactory.TARGET_TYPE_PARAMETER, invocation))) {
            return;
        }
        throw new InvalidInvocationException(invocation, String.format("Unable to transform a %s column into a %s column", sourceDataType.getName(), newDataType.getName()));
    }

    private void checkInvocation(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation);
        this.checkTargetColumnEligibility(invocation);
    }

    private void checkTargetColumnEligibility(OperationInvocation invocation) throws InvalidInvocationException {
        Table table = this.cubeManager.getTable(invocation.getTargetTableId());
        Column column = table.getColumnById(invocation.getTargetColumnId());
        if (!allowedSourceColumnTypes.contains(column.getColumnType().getClass())) {
            throw new InvalidInvocationException(invocation, "Source column is invalid: " + column.getColumnType());
        }
    }

    protected List<Parameter> getParameters() {
        return parameters;
    }

    protected OperationId getOperationId() {
        return OPERATION_ID;
    }

    public List<WorkerFactory> getPrecoditionValidations() {
        return Arrays.asList(new WorkerFactory[]{this.fallbackFactory});
    }

    static {
        parameters.add((Parameter)ColumnTypeCastValidatorFactory.TARGET_TYPE_PARAMETER);
        allowedSourceColumnTypes.add(AnnotationColumnType.class);
        allowedSourceColumnTypes.add(TimeDimensionColumnType.class);
        allowedSourceColumnTypes.add(DimensionColumnType.class);
        allowedSourceColumnTypes.add(AttributeColumnType.class);
        allowedSourceColumnTypes.add(CodeColumnType.class);
        allowedSourceColumnTypes.add(CodeNameColumnType.class);
        allowedSourceColumnTypes.add(CodeDescriptionColumnType.class);
        allowedSourceColumnTypes.add(MeasureColumnType.class);
    }
}

