/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.column.typechange;

import java.util.List;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.operation.factories.types.ColumnTransformationWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.worker.EligibleOperation;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationNotEligibleException;

public abstract class ChangeColumnTypeTransformationFactory
extends ColumnTransformationWorkerFactory {
    protected CubeManager cubeManager;

    public ChangeColumnTypeTransformationFactory(CubeManager cubeManager) {
        this.cubeManager = cubeManager;
    }

    public EligibleOperation getEligibleOperation(TableId tableId, ColumnLocalId columnId) throws OperationNotEligibleException {
        this.checkTargetColumn(tableId, columnId);
        Table table = this.cubeManager.getTable(tableId);
        Column column = table.getColumnById(columnId);
        return new EligibleOperation(this.getOperationDescriptor(), this.createParameters(column), tableId, columnId);
    }

    private void checkTargetColumn(TableId tableId, ColumnLocalId columnId) throws OperationNotEligibleException {
        Table table = this.cubeManager.getTable(tableId);
        Column column = table.getColumnById(columnId);
        if (!this.getAllowedSourceColumnTypes().contains(column.getColumnType().getClass())) {
            throw new OperationNotEligibleException(tableId, columnId, "Cannot perform operation for the given column type: " + column.getColumnType());
        }
    }

    protected String getOperationName() {
        return String.format("Change to %s column", this.getManagedColumnType());
    }

    protected String getOperationDescription() {
        return String.format("Change the column type to %1$s or modify %1$s column", this.getManagedColumnType().getName());
    }

    protected abstract ColumnType getManagedColumnType();

    protected abstract List<Parameter> createParameters(Column var1);

    protected abstract List<Class<? extends ColumnType>> getAllowedSourceColumnTypes();

    protected void checkInvocation(OperationInvocation invocation) throws InvalidInvocationException {
        this.checkTableIdPresence(invocation);
        this.checkColumnIdPresence(invocation);
        try {
            this.getEligibleOperation(invocation.getTargetTableId(), invocation.getTargetColumnId());
        }
        catch (OperationNotEligibleException e) {
            throw new InvalidInvocationException(invocation, (Exception)((Object)e));
        }
    }
}

