/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.column;

import com.google.common.collect.Lists;
import java.util.List;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.worker.BaseWorker;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.OperationException;

public class RemoveColumn
extends BaseWorker {
    CubeManager cubeManager;
    Table targetTable;
    Column targetColumn;

    public RemoveColumn(CubeManager cubeManager, OperationInvocation invocation) {
        super(invocation);
        this.cubeManager = cubeManager;
        this.targetTable = cubeManager.getTable(invocation.getTargetTableId());
        this.targetColumn = this.targetTable.getColumnById(invocation.getTargetColumnId());
    }

    public void run() {
        try {
            this.inProgress(0.1f);
            Table resultTable = this.cubeManager.createTable(this.targetTable.getTableType()).like(this.targetTable, true, (List)Lists.newArrayList((Object[])new Column[]{this.targetColumn})).create();
            this.succeed(resultTable);
        }
        catch (Exception e) {
            this.fail(new OperationException("Unable to create table with removed column", (Throwable)e));
        }
    }
}

