package org.gcube.data.analysis.tabulardata.operation.column.typechange;

import java.util.Collection;
import java.util.List;
import java.util.Locale;

import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.metadata.NoSuchMetadataException;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ColumnMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.DataLocaleMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;

import com.google.common.collect.Lists;

public class DefaultColumnTypeTransformation extends ChangeColumnTypeTransformation {
	
	private ColumnType managedColumnType;

	public DefaultColumnTypeTransformation(OperationInvocation invocation, CubeManager cubeManager,
			DatabaseConnectionProvider databaseConnectionProvider, ColumnType managedColumnType) {
		super(invocation, cubeManager, databaseConnectionProvider);
		this.managedColumnType = managedColumnType;
	}

	@Override
	protected Collection<ColumnMetadata> getMetadataToSet() {
		return collectMetadataToSet(invocation);
	}

	private Collection<ColumnMetadata> collectMetadataToSet(OperationInvocation invocation) {
		List<ColumnMetadata> result = Lists.newArrayList();

		LocalizedText newLabel = retrieveLabelParameter(invocation);
		if (newLabel != null) {
			NamesMetadata newNamesMeta = new NamesMetadata();
			NamesMetadata oldNamesMeta;
			try {
				oldNamesMeta = targetColumn.getMetadata(NamesMetadata.class);
			} catch (NoSuchMetadataException e) {
				oldNamesMeta = new NamesMetadata();
			}
			newNamesMeta.setTexts(oldNamesMeta.getTexts());
			newNamesMeta.addText(newLabel);
			result.add(newNamesMeta);
		}

		Locale dataLocale = retrieveDataLocaleParameter(invocation);
		if (dataLocale != null) {
			result.add(new DataLocaleMetadata(dataLocale));
		}
		return result;
	}

	private LocalizedText retrieveLabelParameter(OperationInvocation invocation) {
		return (LocalizedText) invocation.getParameterInstances().get(DefaultColumnTypeTransformationFactory.LABEL_ID);
	}

	private Locale retrieveDataLocaleParameter(OperationInvocation invocation) {
		return (Locale) invocation.getParameterInstances().get(DefaultColumnTypeTransformationFactory.DATA_LOCALE_ID);
	}

	@Override
	protected ColumnType getManagedColumnType() {
		return managedColumnType;
	}

}
