package org.gcube.data.analysis.tabulardata.operation.column.typechange;

import javax.inject.Inject;
import javax.inject.Singleton;

import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AnnotationColumnType;

@Singleton
public class ChangeToAnnotationColumnFactory extends DefaultColumnTypeTransformationFactory {

	public static final AnnotationColumnType MANAGED_COLUMN_TYPE = new AnnotationColumnType();

	@Inject
	public ChangeToAnnotationColumnFactory(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider) {
		super(cubeManager, connectionProvider);
	}

	@Override
	protected ColumnType getManagedColumnType() {
		return MANAGED_COLUMN_TYPE;
	}

}
