package org.gcube.data.analysis.tabulardata.operation.labels;

import java.util.ArrayList;
import java.util.List;

import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.exceptions.NoSuchTableException;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableMetaCreator;
import org.gcube.data.analysis.tabulardata.metadata.NoSuchMetadataException;
import org.gcube.data.analysis.tabulardata.model.exceptions.NoSuchColumnException;
import org.gcube.data.analysis.tabulardata.model.metadata.common.LocalizedText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddColumnName extends Worker {

	private static final Logger log = LoggerFactory.getLogger(AddColumnName.class);
	
	private CubeManager cubeManager;

	private LocalizedText nameToSet = null;
	
	public AddColumnName(CubeManager cubeManager,OperationInvocation Invocation) {
		super(Invocation);
		this.cubeManager = cubeManager;
	}

	@Override
	protected WorkerResult execute() throws WorkerException {
		retrieveNameToSet();
		updateProgress(0.3f);
		Table resultTable=createTableWithNewColumnLabel();
		return new ImmutableWorkerResult(resultTable);
	}

	private void retrieveNameToSet() {
		nameToSet = (LocalizedText) getSourceInvocation().getParameterInstances().get(
				AddColumnNameFactory.NAME_LABEL_PARAMETER.getIdentifier());
	}
	
	private Table createTableWithNewColumnLabel(){
		TableMetaCreator tmc=cubeManager.modifyTableMeta(getSourceInvocation().getTargetTableId());
		NamesMetadata oldNamesMetadata=getOldNamesMetadata();
		List<LocalizedText> oldTexts = oldNamesMetadata.getTexts();
		List<LocalizedText> newTexts = new ArrayList<LocalizedText>();
		
		//Skip labels with the same locale as newer one
		for(LocalizedText existent:oldTexts)
			if(!existent.getLocale().equalsIgnoreCase(nameToSet.getLocale()))
				newTexts.add(existent);
		
		newTexts.add(nameToSet);
		log.debug("Setting names: " + newTexts);
		NamesMetadata newNamesMetadata = new NamesMetadata(newTexts);
		tmc.setColumnMetadata(getSourceInvocation().getTargetColumnId(), newNamesMetadata);
		return tmc.create();
	}
	
	private NamesMetadata getOldNamesMetadata(){
		try {
			return cubeManager.getTable(getSourceInvocation().getTargetTableId()).
					getColumnById(getSourceInvocation().getTargetColumnId()).getMetadata(NamesMetadata.class);
		} catch (NoSuchColumnException e) {
			throw new RuntimeException("Provided target column id does not exist");
		} catch (NoSuchTableException e) {
			throw new RuntimeException("Provided target table id does not exist");
		} catch (NoSuchMetadataException e) {
			return new NamesMetadata(new ArrayList<LocalizedText>());
		}
	}
}
