/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.data.add;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.expression.functions.Cast;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.data.add.UnionRollbackWorker;
import org.gcube.data.analysis.tabulardata.operation.data.add.UnionWorker;
import org.gcube.data.analysis.tabulardata.operation.factories.types.TableTransformationWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.CompositeParameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.TargetColumnParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;
import org.gcube.data.analysis.tabulardata.operation.worker.types.DataWorker;
import org.gcube.data.analysis.tabulardata.operation.worker.types.RollbackWorker;

@Singleton
public class UnionFactory
extends TableTransformationWorkerFactory {
    private static final OperationId OPERATION_ID = new OperationId(3208L);
    public static final TargetColumnParameter SOURCE_COLUMN_PARAMETER = new TargetColumnParameter("source", "Source", "Source column", Cardinality.ONE);
    public static final TargetColumnParameter TARGET_COLUMN_PARAMETER = new TargetColumnParameter("target", "Target", "Target Column", Cardinality.ONE);
    public static final CompositeParameter MAPPINGS_PARAMETER = new CompositeParameter("mappings", "Mappings", "Mappings betweeen target and source table columns", new Cardinality(1, Integer.MAX_VALUE), Arrays.asList(SOURCE_COLUMN_PARAMETER, TARGET_COLUMN_PARAMETER));
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private SQLExpressionEvaluatorFactory evaluatorFactory;

    @Inject
    public UnionFactory(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, SQLExpressionEvaluatorFactory evaluatorFactory) {
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.evaluatorFactory = evaluatorFactory;
    }

    public DataWorker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        this.checkMappings(invocation);
        return new UnionWorker(invocation, this.cubeManager, this.connectionProvider, this.evaluatorFactory);
    }

    protected String getOperationDescription() {
        return "Import data from a compatible table";
    }

    protected OperationId getOperationId() {
        return OPERATION_ID;
    }

    protected String getOperationName() {
        return "Union";
    }

    protected List<Parameter> getParameters() {
        return Collections.singletonList(MAPPINGS_PARAMETER);
    }

    public String describeInvocation(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        ColumnReference ref = (ColumnReference)UnionFactory.getMappings(invocation).get(0).get(SOURCE_COLUMN_PARAMETER.getIdentifier());
        Table sourceTable = this.cubeManager.getTable(ref.getTableId());
        return String.format("Import %s rows", OperationHelper.retrieveTableLabel((Table)sourceTable));
    }

    private void checkMappings(OperationInvocation invocation) throws InvalidInvocationException {
        List<Map<String, Object>> mappings = UnionFactory.getMappings(invocation);
        Table source = null;
        Table target = this.cubeManager.getTable(invocation.getTargetTableId());
        for (Map<String, Object> mapping : mappings) {
            Column targetCol;
            DataType targetType;
            ColumnReference sourceRef = (ColumnReference)mapping.get(SOURCE_COLUMN_PARAMETER.getIdentifier());
            if (source == null) {
                source = this.cubeManager.getTable(sourceRef.getTableId());
            } else if (!sourceRef.getTableId().equals((Object)source.getId())) {
                throw new InvalidInvocationException(invocation, String.format("Incoherent source table id %s, expected %s", sourceRef.getTableId(), source.getId()));
            }
            ColumnReference targetRef = (ColumnReference)mapping.get(TARGET_COLUMN_PARAMETER.getIdentifier());
            if (!targetRef.getTableId().equals((Object)target.getId())) {
                throw new InvalidInvocationException(invocation, String.format("Incoherent target table id %s, expected %s", targetRef.getTableId(), target.getId()));
            }
            Column sourceCol = source.getColumnById(sourceRef.getColumnId());
            DataType sourceType = sourceCol.getDataType();
            if (Cast.isCastSupported((DataType)sourceType, (DataType)(targetType = (targetCol = target.getColumnById(targetRef.getColumnId())).getDataType()))) continue;
            throw new InvalidInvocationException(invocation, String.format("Cannot map %s values to %s column.", OperationHelper.retrieveColumnLabel((Column)sourceCol), OperationHelper.retrieveColumnLabel((Column)targetCol)));
        }
    }

    protected static List<Map<String, Object>> getMappings(OperationInvocation invocation) {
        Object actualParam = invocation.getParameterInstances().get(MAPPINGS_PARAMETER.getIdentifier());
        if (actualParam instanceof Map) {
            return Collections.singletonList((Map)actualParam);
        }
        Iterable it = (Iterable)actualParam;
        ArrayList<Map<String, Object>> toReturn = new ArrayList<Map<String, Object>>();
        for (Map elem : it) {
            toReturn.add(elem);
        }
        return toReturn;
    }

    public boolean isRollbackable() {
        return true;
    }

    public RollbackWorker createRollbackWoker(Table diffTable, Table createdTable, OperationInvocation oldInvocation) {
        return new UnionRollbackWorker(diffTable, createdTable, oldInvocation, this.cubeManager, this.connectionProvider);
    }
}

