/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.data.transformation;

import java.util.Collections;
import java.util.Map;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.factories.CodeColumnFactory;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableType;
import org.gcube.data.analysis.tabulardata.model.table.type.CodelistTableType;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.data.transformation.ExtractCodelistFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;

public class ExtractCodelist
extends Worker {
    CubeManager cubeManager;
    DatabaseConnectionProvider connectionProvider;
    private Column sourceColumn;
    private Column targetCodeColumn;
    private Table sourceTable;
    private Table targetCodelist;

    public ExtractCodelist(OperationInvocation sourceInvocation, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider) {
        super(sourceInvocation);
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
    }

    protected WorkerResult execute() throws WorkerException {
        this.updateProgress(0.1f, "Initializing");
        this.initialize();
        this.updateProgress(0.3f, "Inserting values into destination codelist");
        this.insertData();
        return new ImmutableWorkerResult(this.sourceTable, Collections.singletonList(this.targetCodelist));
    }

    private void initialize() throws WorkerException {
        OperationInvocation invocation = this.getSourceInvocation();
        Map params = invocation.getParameterInstances();
        this.sourceTable = this.cubeManager.getTable(invocation.getTargetTableId());
        this.sourceColumn = this.sourceTable.getColumnById(((ColumnReference)params.get(ExtractCodelistFactory.VALUES_SOURCE_COLUMN.getIdentifier())).getColumnId());
        if (params.containsKey(ExtractCodelistFactory.TARGET_CODE_COLUMN.getIdentifier())) {
            ColumnReference ref = (ColumnReference)params.get(ExtractCodelistFactory.TARGET_CODE_COLUMN.getIdentifier());
            Table selectedCodelist = this.cubeManager.getTable(ref.getTableId());
            Column selectedCodeColumn = selectedCodelist.getColumnById(ref.getColumnId());
            this.targetCodelist = this.cubeManager.createTable((TableType)new CodelistTableType()).like(selectedCodelist, true).create();
            this.targetCodeColumn = this.targetCodelist.getColumnById(ref.getColumnId());
        } else {
            this.targetCodeColumn = new CodeColumnFactory().createDefault();
            this.targetCodelist = this.cubeManager.createTable((TableType)new CodelistTableType()).addColumn(this.targetCodeColumn).create();
        }
    }

    private void insertData() throws WorkerException {
        String selectCmd = String.format("SELECT distinct(%s) as %s FROM %s", this.sourceColumn.getName(), this.targetCodeColumn.getName(), this.sourceTable.getName());
        String insertCmd = String.format("INSERT INTO %s (%s) (%s)", this.targetCodelist.getName(), this.targetCodeColumn.getName(), selectCmd);
        try {
            SQLHelper.executeSQLCommand((String)insertCmd, (DatabaseConnectionProvider)this.connectionProvider);
        }
        catch (Exception e) {
            throw new WorkerException("Error occurred while performing insert query", (Throwable)e);
        }
    }
}

