/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.data.remove;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.data.remove.RemoveColumn;
import org.gcube.data.analysis.tabulardata.operation.data.remove.RemoveColumnRollbackWorker;
import org.gcube.data.analysis.tabulardata.operation.factories.types.ColumnTransformationWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.worker.RollbackWorker;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;

@Singleton
public class RemoveColumnFactory
extends ColumnTransformationWorkerFactory {
    private static final OperationId OPERATION_ID = new OperationId(1004L);
    @Inject
    private CubeManager cubeManager;
    @Inject
    private DatabaseConnectionProvider connectionProvider;

    public Worker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        return new RemoveColumn(this.cubeManager, invocation);
    }

    public boolean isRollbackable() {
        return true;
    }

    public RollbackWorker createRollbackWoker(Table diffTable, Table createdTable, OperationInvocation oldInvocation) {
        return new RemoveColumnRollbackWorker(diffTable, createdTable, oldInvocation, this.cubeManager, this.connectionProvider);
    }

    protected String getOperationName() {
        return "Remove column";
    }

    protected String getOperationDescription() {
        return "Remove column from table";
    }

    protected OperationId getOperationId() {
        return OPERATION_ID;
    }

    protected List<Parameter> getParameters() {
        return new ArrayList<Parameter>();
    }

    public String describeInvocation(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        Column col = this.cubeManager.getTable(invocation.getTargetTableId()).getColumnById(invocation.getTargetColumnId());
        return String.format("Remove column %s", OperationHelper.retrieveColumnLabel((Column)col));
    }
}

