/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.data.remove;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.data.remove.DuplicateRowRemover;
import org.gcube.data.analysis.tabulardata.operation.data.remove.RowRecoveryRollbackWorker;
import org.gcube.data.analysis.tabulardata.operation.factories.types.TableTransformationWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.validation.DuplicateRowValidatorFactory;
import org.gcube.data.analysis.tabulardata.operation.worker.RollbackWorker;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;

@Singleton
public class DuplicateRowRemoverFactory
extends TableTransformationWorkerFactory {
    private static final OperationId OPERATION_ID = new OperationId(3007L);
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private SQLExpressionEvaluatorFactory sqlEvaluatorFactory;
    private DuplicateRowValidatorFactory validatorFactory;
    private static List<Parameter> params = new ArrayList<Parameter>();

    public Worker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation, this.cubeManager);
        return new DuplicateRowRemover(invocation, this.cubeManager, this.connectionProvider, this.sqlEvaluatorFactory, this.validatorFactory);
    }

    public RollbackWorker createRollbackWoker(Table diffTable, Table createdTable, OperationInvocation oldInvocation) {
        return new RowRecoveryRollbackWorker(diffTable, createdTable, oldInvocation, this.cubeManager, this.connectionProvider);
    }

    public boolean isRollbackable() {
        return true;
    }

    @Inject
    public DuplicateRowRemoverFactory(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, SQLExpressionEvaluatorFactory sqlEvaluatorFactory, DuplicateRowValidatorFactory validatorFactory) {
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.sqlEvaluatorFactory = sqlEvaluatorFactory;
        this.validatorFactory = validatorFactory;
    }

    protected String getOperationName() {
        return "Remove duplicate tuples";
    }

    protected String getOperationDescription() {
        return "Remove tuples that presents the same data";
    }

    protected List<Parameter> getParameters() {
        return params;
    }

    protected OperationId getOperationId() {
        return OPERATION_ID;
    }

    static {
        params.add((Parameter)DuplicateRowValidatorFactory.KEY);
    }
}

