package org.gcube.data.analysis.tabulardata.operation.data.replace;

import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.MalformedExpressionException;
import org.gcube.data.analysis.tabulardata.expression.composite.comparable.Equals;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDInteger;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDTypeValue;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;

public class ReplaceById extends Worker{


	private CubeManager cubeManager;

	private DatabaseConnectionProvider connectionProvider;

	private SQLExpressionEvaluatorFactory sqlEvaluatorFactory;

	public ReplaceById(OperationInvocation sourceInvocation,
			CubeManager cubeManager,
			DatabaseConnectionProvider connectionProvider,
			SQLExpressionEvaluatorFactory sqlEvaluatorFactory) {
		super(sourceInvocation);
		this.cubeManager = cubeManager;
		this.connectionProvider = connectionProvider;
		this.sqlEvaluatorFactory = sqlEvaluatorFactory;
	}

	private Table targetTable;
	private Column targetColumn;
	private TDTypeValue value;
	private Integer rowId;
	private Table newTable;

	@Override
	protected WorkerResult execute() throws WorkerException {
		try{
			instantiateExecutionVariables();
			updateProgress(0.1f);
			newTable=cubeManager.createTable(targetTable.getTableType()).like(targetTable, true).create();
			updateProgress(0.5f);
			executeBatch();
			updateProgress(0.9f);
			return new ImmutableWorkerResult(newTable);
		}catch (MalformedExpressionException e){
			throw new WorkerException("Passed value is not well formed",e);
		}
	}


	private void instantiateExecutionVariables()throws WorkerException, MalformedExpressionException{
		OperationInvocation invocation=getSourceInvocation();
		targetTable=cubeManager.getTable(invocation.getTargetTableId());
		targetColumn=targetTable.getColumnById(invocation.getTargetColumnId());
		value = (TDTypeValue) invocation.getParameterInstances().get(ReplaceByIdFactory.VALUE.getIdentifier());		
		if(!value.getReturnedDataType().getClass().isAssignableFrom(targetColumn.getDataType().getClass())){
			throw new WorkerException("Target column and passed value has incompatible types");
		}
		rowId=(Integer) invocation.getParameterInstances().get(ReplaceByIdFactory.ID.getIdentifier());
	}

	
	private void executeBatch()throws WorkerException{
		try {
			SQLHelper.executeSQLBatchCommands(connectionProvider, getUpdateStatement());
		} catch (Exception e) {
			throw new WorkerException("Error occurred while executing SQL command", e);
		}
	}
	
	
	private String getUpdateStatement(){
		ColumnReference idColumnReference=newTable.getColumnReference(newTable.getColumnsByType(IdColumnType.class).get(0));		
		return String.format("UPDATE %s SET %s = %s WHERE %s", 
				newTable.getName(), targetColumn.getName(), 
				sqlEvaluatorFactory.getEvaluator(value).evaluate(), 
				sqlEvaluatorFactory.getEvaluator(new Equals(idColumnReference,new TDInteger(rowId))).evaluate());
	}
}
