package org.gcube.data.analysis.tabulardata.operation.data.remove;

import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.ImmutableWorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerResult;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;

import com.google.common.collect.Lists;

public class RemoveColumn extends Worker {
	
	private CubeManager cubeManager;
	
	private Table targetTable;
	
	private Column targetColumn;

	public RemoveColumn(CubeManager cubeManager, OperationInvocation invocation) {
		super(invocation);
		this.cubeManager = cubeManager;
		this.targetTable = cubeManager.getTable(invocation.getTargetTableId());
		this.targetColumn = targetTable.getColumnById(invocation.getTargetColumnId());
	}
	
	@Override
	protected WorkerResult execute() throws WorkerException {
		updateProgress(0.1f);
		Table resultTable = cubeManager.createTable(targetTable.getTableType())
				.like(targetTable, true, Lists.newArrayList(targetColumn)).create();
		return new ImmutableWorkerResult(resultTable);
	}

}
