/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.data.replace;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.data.replace.ReplaceByExpression;
import org.gcube.data.analysis.tabulardata.operation.factories.types.ColumnTransformationWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.ExpressionParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;

@Singleton
public class ReplaceByExpressionFactory
extends ColumnTransformationWorkerFactory {
    private static final OperationId OPERATION_ID = new OperationId(3101L);
    public static final ExpressionParameter CONDITION_PARAMETER = new ExpressionParameter("condition", "Condition", "Boolean condition that identifies to modify rows", Cardinality.ONE);
    public static final ExpressionParameter VALUE_PARAMETER = new ExpressionParameter("value", "Value", "Expression that returns the value to be set", Cardinality.ONE);
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private SQLExpressionEvaluatorFactory sqlEvaluatorFactory;

    @Inject
    public ReplaceByExpressionFactory(CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, SQLExpressionEvaluatorFactory sqlEvaluatorFactory) {
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.sqlEvaluatorFactory = sqlEvaluatorFactory;
    }

    public Worker createWorker(OperationInvocation invocation) throws InvalidInvocationException {
        this.performBaseChecks(invocation);
        return new ReplaceByExpression(invocation, this.cubeManager, this.connectionProvider, this.sqlEvaluatorFactory);
    }

    protected String getOperationDescription() {
        return "Updates the values of the selected column in rows matching the defined condition";
    }

    protected String getOperationName() {
        return "Replace By Expression";
    }

    protected OperationId getOperationId() {
        return OPERATION_ID;
    }

    protected List<Parameter> getParameters() {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add((Parameter)CONDITION_PARAMETER);
        parameters.add((Parameter)VALUE_PARAMETER);
        return parameters;
    }
}

