package org.gcube.data.analysis.tabulardata.operation.data.remove;

import java.util.Arrays;
import java.util.List;

import javax.inject.Singleton;

import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AnnotationColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.AttributeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeDescriptionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.CodeNameColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.DimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.MeasureColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.TimeDimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.table.TableType;
import org.gcube.data.analysis.tabulardata.model.table.type.CodelistTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.DatasetTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.DatasetViewTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.GenericTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.TimeCodelistTableType;
import org.gcube.data.analysis.tabulardata.operation.OperationId;
import org.gcube.data.analysis.tabulardata.operation.factories.types.TableTransformationWorkerFactory;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.parameters.leaves.TargetColumnParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.Worker;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.InvalidInvocationException;

@Singleton
public class AggregateFactory extends TableTransformationWorkerFactory{
	
	private static final OperationId OPERATION_ID = new OperationId(3006);
	
	public static final TargetColumnParameter TO_AGGREGATE_COLUMNS= new TargetColumnParameter("toAggregateColumns", "To Agrgegate Columns", "Columns which values should be aggregated", 
																		new Cardinality(1, Integer.MAX_VALUE), 
																		Arrays.asList(new TableType[]{
																		new CodelistTableType(),
																		new DatasetTableType(),
																		new DatasetViewTableType(),
																		new GenericTableType(),
																		new TimeCodelistTableType()}),
																		Arrays.asList(new ColumnType[]{
																				new AnnotationColumnType(),
																				new AttributeColumnType(),
																				new CodeColumnType(),
																				new CodeDescriptionColumnType(),
																				new CodeNameColumnType(),
																				new DimensionColumnType(),
																				new MeasureColumnType(),
																				new TimeDimensionColumnType()}));

	
	@Override
	public Worker createWorker(OperationInvocation arg0)
			throws InvalidInvocationException {
		// TODO Auto-generated method stub
		return null;
	}
	
	
	public AggregateFactory() {
		// TODO Auto-generated constructor stub
	}


	@Override
	protected String getOperationDescription() {
		// TODO Auto-generated method stub
		return null;
	}


	@Override
	protected String getOperationName() {
		// TODO Auto-generated method stub
		return null;
	}


	@Override
	protected List<Parameter> getParameters() {
		// TODO Auto-generated method stub
		return null;
	}
}
