/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.csv.exporter;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.MemoryType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.metadata.common.NamesMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ImmutableURIResult;
import org.gcube.data.analysis.tabulardata.operation.worker.results.resources.ResourceDescriptorResult;
import org.gcube.data.analysis.tabulardata.operation.worker.types.ResourceCreatorWorker;
import org.postgresql.PGConnection;
import org.postgresql.copy.CopyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVExport
extends ResourceCreatorWorker {
    private static Logger logger = LoggerFactory.getLogger(CSVExport.class);
    CubeManager cubeManager;
    DatabaseConnectionProvider connectionProvider;
    private String encoding;
    private Character separator;
    private List<String> selectedColumns;

    public CSVExport(OperationInvocation invocation, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider) {
        super(invocation);
        this.retrieveParameters();
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
    }

    public ResourceDescriptorResult execute() throws WorkerException {
        String url;
        File exportFile;
        Table table = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
        this.updateProgress(0.1f, "Creating export file");
        try {
            exportFile = File.createTempFile("export", ".csv");
        }
        catch (Exception e) {
            logger.error("error creating file", (Throwable)e);
            throw new WorkerException("error creating file", (Throwable)e);
        }
        this.updateProgress(0.3f, "Writing file with data");
        OutputStreamWriter outputStreamWriter = null;
        try {
            try {
                outputStreamWriter = new OutputStreamWriter(new FileOutputStream(exportFile));
                long updated = this.copy(outputStreamWriter, table, this.getSourceInvocation().getParameterInstances());
                logger.debug("exported " + updated + " entries");
            }
            catch (Exception e) {
                logger.error("error copying table to file", (Throwable)e);
                exportFile.delete();
                throw new WorkerException("error copying table to file", (Throwable)e);
            }
        }
        finally {
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException e) {
                    logger.warn("error closing output stream", (Throwable)e);
                }
            }
        }
        this.updateProgress(0.7f, "Storing file on storage");
        try {
            try {
                url = this.storeFile(exportFile);
            }
            catch (Exception e) {
                logger.error("error storing file", (Throwable)e);
                throw new WorkerException("error storing file", (Throwable)e);
            }
        }
        finally {
            exportFile.delete();
        }
        this.updateProgress(0.9f, "Finalizing");
        return this.createDescriptor(url);
    }

    private String storeFile(File exportFile) {
        IClient client = new StorageClient("DataAnalysis", "TabularData", "CSVExport", AccessType.SHARED, MemoryType.VOLATILE).getClient();
        String remotePath = "/CSVexport/" + exportFile.getName();
        client.put(true).LFile(exportFile.getAbsolutePath()).RFile(remotePath);
        return client.getUrl().RFile(remotePath);
    }

    private ResourceDescriptorResult createDescriptor(String url) throws WorkerException {
        try {
            return new ImmutableURIResult(new URI(url), "csv exported file", Calendar.getInstance());
        }
        catch (URISyntaxException e) {
            throw new WorkerException("exported url not valid", (Throwable)e);
        }
    }

    private long copy(OutputStreamWriter outputStreamWriter, Table table, Map<String, Object> parameters) throws Exception {
        PGConnection conn = this.connectionProvider.getPostgreSQLConnection();
        CopyManager cpManager = conn.getCopyAPI();
        StringBuilder columns = new StringBuilder("SELECT ");
        for (Column c : table.getColumns()) {
            if (!this.selectedColumns.contains(c.getName())) continue;
            String label = c.getName();
            try {
                NamesMetadata metadata = (NamesMetadata)c.getMetadata(NamesMetadata.class);
                if (metadata.hasTextWithLocale("en")) {
                    label = metadata.getTextWithLocale("en").getValue();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (label.isEmpty()) {
                label = c.getLocalId().getValue();
            }
            columns.append(c.getName()).append(" as ").append(String.format("\"%s\"", label));
            columns.append(",");
        }
        columns.deleteCharAt(columns.length() - 1);
        columns.append(" from " + table.getName());
        String sqlCmd = String.format("COPY ( %s ) TO STDOUT ( FORMAT CSV ,DELIMITER '%c', HEADER %b, ENCODING '%s');", columns.toString(), this.separator, true, this.encoding);
        logger.info("executing copy for csv import with query {}", (Object)sqlCmd);
        return cpManager.copyOut(sqlCmd, (Writer)outputStreamWriter);
    }

    private void retrieveParameters() {
        Map parameters = this.getSourceInvocation().getParameterInstances();
        this.separator = Character.valueOf(((String)parameters.get("separator")).charAt(0));
        this.encoding = (String)parameters.get("encoding");
        this.selectedColumns = new ArrayList<String>();
        Object columnsParam = parameters.get("columns");
        if (columnsParam instanceof Iterable) {
            for (String col : (Iterable)columnsParam) {
                this.selectedColumns.add(col);
            }
        } else {
            this.selectedColumns.add((String)columnsParam);
        }
    }
}

