/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.comet;

import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.metadata.NoSuchMetadataException;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.metadata.table.HarmonizationRuleTable;
import org.gcube.data.analysis.tabulardata.model.metadata.table.TableMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.SQLHelper;
import org.gcube.data.analysis.tabulardata.operation.comet.ImportCodeListMappingFactory;
import org.gcube.data.analysis.tabulardata.operation.comet.MappingParser;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;
import org.gcube.data.analysis.tabulardata.operation.worker.exceptions.WorkerException;
import org.gcube.data.analysis.tabulardata.operation.worker.results.EmptyType;
import org.gcube.data.analysis.tabulardata.operation.worker.types.MetadataWorker;

public class ImportCodelistMappingWorker
extends MetadataWorker {
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private SQLExpressionEvaluatorFactory evaluatorFactory;
    private Table targetCodelist;
    private Table previousVersionCodelist = null;
    private Column oldCodesColumn = null;
    private String mappingUri = null;

    public ImportCodelistMappingWorker(OperationInvocation sourceInvocation, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider, SQLExpressionEvaluatorFactory evaluatorFactory) {
        super(sourceInvocation);
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        this.evaluatorFactory = evaluatorFactory;
    }

    protected EmptyType execute() throws WorkerException {
        this.updateProgress(0.1f, "Initializing..");
        this.targetCodelist = this.cubeManager.getTable(this.getSourceInvocation().getTargetTableId());
        ColumnReference oldCodesReference = (ColumnReference)OperationHelper.getParameter((LeafParameter)ImportCodeListMappingFactory.PREVIOUS_VERSION_CODELIST_PARAMETER, (OperationInvocation)this.getSourceInvocation());
        this.previousVersionCodelist = this.cubeManager.getTable(oldCodesReference.getTableId());
        this.oldCodesColumn = this.previousVersionCodelist.getColumnById(oldCodesReference.getColumnId());
        this.mappingUri = (String)OperationHelper.getParameter((LeafParameter)ImportCodeListMappingFactory.ID_PARAMETER, (OperationInvocation)this.getSourceInvocation());
        MappingParser.ParserConfiguration config = new MappingParser.ParserConfiguration(this.previousVersionCodelist, this.targetCodelist, this.oldCodesColumn);
        try {
            this.updateProgress(0.3f, "Parsing mapping..");
            MappingParser parser = new MappingParser(config, this.evaluatorFactory, this.cubeManager, this.connectionProvider);
            parser.parse(this.mappingUri);
            Table rulesTable = parser.getRulesTable();
            this.updateProgress(0.8f, "Attaching rules to codelist..");
            try {
                HarmonizationRuleTable existingMeta = (HarmonizationRuleTable)this.targetCodelist.getMetadata(HarmonizationRuleTable.class);
                Table existingRules = existingMeta.getRulesTable();
                String colSnippet = "enabled,referred_column,to_change_value_description,to_change_value,to_set_value_description,to_set_value";
                String sqlCommand = String.format("Insert into %1$s (%2$s) (SELECT %2$s FROM %3$s)", existingRules.getName(), colSnippet, rulesTable.getName());
                SQLHelper.executeSQLCommand((String)sqlCommand, (DatabaseConnectionProvider)this.connectionProvider);
            }
            catch (NoSuchMetadataException e) {
                this.targetCodelist = this.cubeManager.modifyTableMeta(this.targetCodelist.getId()).setTableMetadata(new TableMetadata[]{new HarmonizationRuleTable(rulesTable)}).create();
            }
            return EmptyType.instance();
        }
        catch (Exception e) {
            throw new WorkerException("Processing failed " + e.getMessage());
        }
    }
}

