/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.comet;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.dbutils.DbUtils;
import org.fao.fi.comet.mapping.model.Mapping;
import org.fao.fi.comet.mapping.model.MappingData;
import org.fao.fi.comet.mapping.model.MappingDetail;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.evaluator.sql.SQLExpressionEvaluatorFactory;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDTypeValue;
import org.gcube.data.analysis.tabulardata.model.harmonization.HarmonizationRule;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.operation.HarmonizationRuleHelper;
import org.gcube.data.analysis.tabulardata.operation.OperationHelper;
import org.gcube.data.analysis.tabulardata.operation.comet.model.MappedRow;
import org.gcube.data.analysis.tabulardata.operation.comet.model.MappedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingParser {
    private static Logger logger = LoggerFactory.getLogger(MappingParser.class);
    private ParserConfiguration config;
    private SQLExpressionEvaluatorFactory evaluatorFactory;
    private CubeManager cubeManager;
    private DatabaseConnectionProvider connectionProvider;
    private Marshaller marshaller;
    private long foundMappingsCount = 0L;
    private long parsedRulesCount = 0L;
    private Table rulesTable = null;
    private Connection conn = null;
    private PreparedStatement stmt = null;

    public MappingParser(ParserConfiguration config, SQLExpressionEvaluatorFactory evaluatorFactory, CubeManager cubeManager, DatabaseConnectionProvider connectionProvider) throws IOException, JAXBException {
        this.config = config;
        this.evaluatorFactory = evaluatorFactory;
        this.cubeManager = cubeManager;
        this.connectionProvider = connectionProvider;
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Expression.class});
        this.marshaller = jaxbContext.createMarshaller();
        this.marshaller.setProperty("jaxb.formatted.output", (Object)true);
    }

    public void parse(String xmlFile) throws Exception {
        XMLStreamReader xmler = null;
        try {
            if (this.rulesTable == null) {
                this.rulesTable = HarmonizationRuleHelper.createTable((CubeManager)this.cubeManager);
            }
            logger.debug("Parsing file " + xmlFile);
            XMLInputFactory xmlif = XMLInputFactory.newInstance();
            xmler = xmlif.createXMLStreamReader(OperationHelper.getInputStreamFromUrl((String)xmlFile));
            JAXBContext ctxUnmarshall = JAXBContext.newInstance((Class[])new Class[]{MappingData.class});
            MappingData deserialized = (MappingData)ctxUnmarshall.createUnmarshaller().unmarshal(xmler);
            Collection mappings = deserialized.getMappings();
            logger.debug("Parsed {} mappings", (Object)mappings.size());
            this.foundMappingsCount = mappings.size();
            for (Mapping mapping : mappings) {
                try {
                    MappedRow sourceRow = new MappedRow(mapping.getSource());
                    for (MappingDetail targetCandidate : mapping.getTargets()) {
                        if (!(targetCandidate.getScore() >= this.config.getScoreThreshold())) continue;
                        MappedRow targetRow = new MappedRow(targetCandidate.getTargetElement());
                        List<MappedValue> mappedValueList = this.config.getDirection().equals((Object)MappingDirection.FORWARD) ? this.getChangeSet(sourceRow, targetRow) : this.getChangeSet(targetRow, sourceRow);
                        for (MappedValue mapped : mappedValueList) {
                            HarmonizationRule rule = this.getRule(mapped);
                            this.storeRule(rule);
                            System.out.println(rule);
                            ++this.parsedRulesCount;
                        }
                    }
                }
                catch (Throwable t) {
                    logger.debug("Skipping mapping for source element {} ", (Object)mapping.getSource().getId().getElementId());
                }
            }
            logger.debug(String.format("Generated %s rules out of %s mappings into %s table.", this.parsedRulesCount, this.foundMappingsCount, this.rulesTable));
        }
        finally {
            if (xmler != null) {
                xmler.close();
            }
            if (this.stmt != null) {
                DbUtils.closeQuietly((Statement)this.stmt);
            }
            if (this.conn != null) {
                DbUtils.closeQuietly((Connection)this.conn);
            }
        }
    }

    private HarmonizationRule getRule(MappedValue mapped) throws Exception {
        Column referred = this.getConfig().getCurrentCodelistVersion().getColumnByLabel(mapped.getFieldLabel());
        TDTypeValue targetValue = referred.getDataType().fromString(mapped.getTargetValue());
        TDTypeValue sourceValue = referred.getDataType().fromString(mapped.getSourceValue());
        return new HarmonizationRule(sourceValue, targetValue, (ColumnReference)this.getConfig().getCurrentCodelistVersion().getColumnReference(referred), Boolean.valueOf(true), (String)this.evaluatorFactory.getEvaluator((Expression)sourceValue).evaluate(), (String)this.evaluatorFactory.getEvaluator((Expression)targetValue).evaluate());
    }

    private int storeRule(HarmonizationRule r) throws SQLException, JAXBException {
        if (this.conn == null) {
            this.conn = this.connectionProvider.getConnection();
        }
        if (this.stmt == null) {
            String insertStatement = "INSERT INTO " + this.rulesTable.getName() + "(" + "enabled" + "," + "referred_column" + "," + "to_change_value" + "," + "to_change_value_description" + "," + "to_set_value" + "," + "to_set_value_description" + ") VALUES (?,?,?,?,?,?)";
            this.stmt = this.conn.prepareStatement(insertStatement);
        }
        this.stmt.setBoolean(1, r.isEnabled());
        this.stmt.setString(2, r.getReferredCodelistColumn().getColumnId().toString());
        this.stmt.setString(3, this.serializeExpression((Expression)r.getToChangeValue()));
        this.stmt.setString(4, r.getToChangeValueDescription());
        this.stmt.setString(5, this.serializeExpression((Expression)r.getToSetValue()));
        this.stmt.setString(6, r.getToSetValueDescription());
        return this.stmt.executeUpdate();
    }

    private List<MappedValue> getChangeSet(MappedRow original, MappedRow newRow) throws Exception {
        ArrayList<MappedValue> toReturn = new ArrayList<MappedValue>();
        for (Map.Entry originalEntry : original.entrySet()) {
            if (!newRow.containsKey(originalEntry.getKey()) || ((String)originalEntry.getValue()).equals(newRow.get(originalEntry.getKey()))) continue;
            toReturn.add(new MappedValue((String)originalEntry.getValue(), (String)newRow.get(originalEntry.getKey()), (String)originalEntry.getKey()));
        }
        return toReturn;
    }

    private String serializeExpression(Expression toSerialize) throws JAXBException {
        StringWriter stringWriter = new StringWriter();
        this.marshaller.marshal((Object)toSerialize, (Writer)stringWriter);
        return stringWriter.toString();
    }

    public ParserConfiguration getConfig() {
        return this.config;
    }

    public long getParsedRulesCount() {
        return this.parsedRulesCount;
    }

    public long getFoundMappingsCount() {
        return this.foundMappingsCount;
    }

    public Table getRulesTable() {
        return this.rulesTable;
    }

    public static enum MappingDirection {
        FORWARD,
        BACKWARD;

    }

    public static class ParserConfiguration {
        private Table previousCodelistVersion;
        private Table currentCodelistVersion;
        private double scoreThreshold = 1.0;
        private boolean skipOnError = true;
        private MappingDirection direction = MappingDirection.BACKWARD;

        public ParserConfiguration(Table previousCodelistVersion, Table currentCodelistVersion) {
            this.previousCodelistVersion = previousCodelistVersion;
            this.currentCodelistVersion = currentCodelistVersion;
        }

        public Table getCurrentCodelistVersion() {
            return this.currentCodelistVersion;
        }

        public Table getPreviousCodelistVersion() {
            return this.previousCodelistVersion;
        }

        public void setDirection(MappingDirection direction) {
            this.direction = direction;
        }

        public MappingDirection getDirection() {
            return this.direction;
        }

        public boolean isSkipOnError() {
            return this.skipOnError;
        }

        public double getScoreThreshold() {
            return this.scoreThreshold;
        }

        public void setScoreThreshold(double scoreThreshold) {
            this.scoreThreshold = scoreThreshold;
        }

        public void setSkipOnError(boolean skipOnError) {
            this.skipOnError = skipOnError;
        }
    }
}

