/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.comet.model;

import java.util.Collections;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.factories.AttributeColumnFactory;
import org.gcube.data.analysis.tabulardata.model.datatype.BooleanType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDTypeValue;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableType;
import org.gcube.data.analysis.tabulardata.model.table.type.GenericTableType;

public class Rule {
    public static final String TO_CHANGE_VALUE_FIELD = "to_change_value";
    public static final String TO_SET_VALUE_FIELD = "to_set_value";
    public static final String REFERRED_CODELIST_COLUMN = "referred_column";
    public static final String ENABLED = "enabled";
    public static final String ID = "id";
    public static final String TO_CHANGE_VALUE_DESCRIPTION = "to_change_value_description";
    public static final String TO_SET_VALUE_DESCRIPTION = "to_set_value_description";
    private TDTypeValue toChangeValue;
    private TDTypeValue toSetValue;
    private ColumnReference referredCodelistColumn;
    private Boolean enabled = true;
    private long id = 0L;
    private String toChangeValueDescription;
    private String toSetValueDescription;

    public Rule(TDTypeValue toChangeValue, TDTypeValue toSetValue, ColumnReference reference) {
        this.toChangeValue = toChangeValue;
        this.toSetValue = toSetValue;
        this.referredCodelistColumn = reference;
    }

    public Rule(TDTypeValue toChangeValue, TDTypeValue toSetValue, ColumnReference reference, Boolean enabled, String toChangeValueDescription, String toSetValueDescription) {
        this.toChangeValue = toChangeValue;
        this.toSetValue = toSetValue;
        this.referredCodelistColumn = reference;
        this.enabled = enabled;
        this.toChangeValueDescription = toChangeValueDescription;
        this.toSetValueDescription = toSetValueDescription;
    }

    public TDTypeValue getToChangeValue() {
        return this.toChangeValue;
    }

    public void setToChangeValue(TDTypeValue toChangeValue) {
        this.toChangeValue = toChangeValue;
    }

    public TDTypeValue getToSetValue() {
        return this.toSetValue;
    }

    public void setToSetValue(TDTypeValue toSetValue) {
        this.toSetValue = toSetValue;
    }

    public ColumnReference getReferredCodelistColumn() {
        return this.referredCodelistColumn;
    }

    public void setReferredCodelistColumn(ColumnReference referredCodelistColumn) {
        this.referredCodelistColumn = referredCodelistColumn;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getToChangeValueDescription() {
        return this.toChangeValueDescription;
    }

    public void setToChangeValueDescription(String toChangeValueDescription) {
        this.toChangeValueDescription = toChangeValueDescription;
    }

    public String getToSetValueDescription() {
        return this.toSetValueDescription;
    }

    public void setToSetValueDescription(String toSetValueDescription) {
        this.toSetValueDescription = toSetValueDescription;
    }

    public static Table createTable(CubeManager cubeManager) {
        AttributeColumnFactory factory = new AttributeColumnFactory();
        Column toSetCol = factory.create((DataType)new TextType(), Collections.singletonList(new ImmutableLocalizedText("To set value")));
        Column toChangeCol = factory.create((DataType)new TextType(), Collections.singletonList(new ImmutableLocalizedText("To change value")));
        Column toSetColDesc = factory.create((DataType)new TextType(), Collections.singletonList(new ImmutableLocalizedText("To set value description")));
        Column toChangeColDesc = factory.create((DataType)new TextType(), Collections.singletonList(new ImmutableLocalizedText("To change value description")));
        Column enabledCol = factory.create((DataType)new BooleanType(), Collections.singletonList(new ImmutableLocalizedText("Enabled")));
        Column referenceCol = factory.create((DataType)new TextType(), Collections.singletonList(new ImmutableLocalizedText("Referred column")));
        toSetCol.setName(TO_SET_VALUE_FIELD);
        toChangeCol.setName(TO_CHANGE_VALUE_FIELD);
        toSetColDesc.setName(TO_SET_VALUE_DESCRIPTION);
        toChangeColDesc.setName(TO_CHANGE_VALUE_DESCRIPTION);
        enabledCol.setName(ENABLED);
        referenceCol.setName(REFERRED_CODELIST_COLUMN);
        return cubeManager.createTable((TableType)new GenericTableType()).addColumns(new Column[]{toSetCol, toChangeCol, toSetColDesc, toChangeColDesc, enabledCol, referenceCol}).create();
    }

    public String toString() {
        return String.format("col %s, %b  : FROM %s TO %s ", this.getReferredCodelistColumn(), this.isEnabled(), this.getToChangeValueDescription(), this.getToSetValueDescription());
    }
}

