/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.comet.model;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.fao.fi.comet.mapping.model.MappingElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MappedRow
extends HashMap<String, String> {
    private static Logger logger = LoggerFactory.getLogger(MappedRow.class);
    private static SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    private static final String COTRIX_PREFIX = "{http://cotrix.org}";
    private static final String DATE_FIELD = "{http://cotrix.org}updated";
    private static final long serialVersionUID = -8270722918248713285L;
    public String id;
    public Date updated;

    public MappedRow(MappingElement element) {
        this.id = element.getId().getElementId().toString();
        NodeList list = element.getData().getElementsByTagName("Property");
        int i = 0;
        while (i < list.getLength()) {
            block7: {
                Element propElement = (Element)list.item(i);
                try {
                    String name = propElement.getAttribute("name");
                    String type = propElement.getAttribute("type");
                    String value = propElement.getAttribute("value");
                    if (name.startsWith(COTRIX_PREFIX)) {
                        try {
                            if (name.equals(DATE_FIELD)) {
                                this.updated = formatter.parse(value);
                            }
                            break block7;
                        }
                        catch (Exception e) {
                            logger.debug(String.format("Unable to parse field %s [%s] = %s : %s", name, type, value, e.getMessage()));
                        }
                        break block7;
                    }
                    this.put(name, value);
                }
                catch (Throwable t) {
                    logger.debug("Unable to parse property " + propElement, t);
                }
            }
            ++i;
        }
    }

    public String getId() {
        return this.id;
    }

    public Date getUpdated() {
        return this.updated;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MappedRow [id=");
        builder.append(this.id);
        builder.append(", updated=");
        builder.append(this.updated);
        builder.append(", entrySet()=");
        builder.append(this.entrySet());
        builder.append("]");
        return builder.toString();
    }
}

