/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.invocation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.MalformedExpressionException;
import org.gcube.data.analysis.tabulardata.expression.TableReferenceReplacer;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.operation.OperationDescriptor;
import org.gcube.data.analysis.tabulardata.operation.OperationScope;
import org.gcube.data.analysis.tabulardata.operation.invocation.ColumnScopedInvocationCreator;
import org.gcube.data.analysis.tabulardata.operation.invocation.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.invocation.TableScopedInvocationCreator;
import org.gcube.data.analysis.tabulardata.operation.invocation.VoidScopedInvocationCreator;

public abstract class InvocationCreator {
    protected Map<String, Object> parameters;
    protected OperationDescriptor descriptor;
    protected TableId toUpdateTableId = null;
    protected TableId targetTableId = null;
    protected ColumnLocalId targetColumnId = null;

    protected InvocationCreator(OperationDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public static InvocationCreator getCreator(OperationDescriptor descriptor) {
        if (descriptor.getScope() == OperationScope.TABLE) {
            return new TableScopedInvocationCreator(descriptor);
        }
        if (descriptor.getScope() == OperationScope.COLUMN) {
            return new ColumnScopedInvocationCreator(descriptor);
        }
        if (descriptor.getScope() == OperationScope.VOID) {
            return new VoidScopedInvocationCreator(descriptor);
        }
        throw new UnsupportedOperationException("Unable to create an invocation creator for the given operation scope: " + (Object)((Object)descriptor.getScope()));
    }

    public abstract OperationInvocation create();

    public InvocationCreator setTargetTable(TableId tableId) {
        this.targetTableId = tableId;
        return this;
    }

    public InvocationCreator setTargetColumn(ColumnLocalId columnId) {
        this.targetColumnId = columnId;
        return this;
    }

    public InvocationCreator setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
        return this;
    }

    public InvocationCreator setToUpdateReferredTable(TableId toUpdateId) {
        this.toUpdateTableId = toUpdateId;
        return this;
    }

    protected void updateReferredTableId() {
        if (this.targetTableId != null && this.parameters != null && this.toUpdateTableId != null && !this.toUpdateTableId.equals((Object)this.targetTableId)) {
            HashMap<String, Object> newParameters = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
                Object toSet = InvocationCreator.updateParameterReferences(entry.getValue(), this.toUpdateTableId, this.targetTableId);
                newParameters.put(entry.getKey(), toSet);
            }
            this.parameters = newParameters;
        }
    }

    private static final Object updateParameterReferences(Object param, TableId oldTableId, TableId toSetTableId) {
        if (param != null) {
            if (param instanceof TableId) {
                TableId oldParam = (TableId)param;
                if (oldParam.equals((Object)oldTableId)) {
                    return toSetTableId;
                }
                return oldParam;
            }
            if (param instanceof ColumnReference) {
                ColumnReference oldParam = (ColumnReference)param;
                if (oldParam.getTableId().equals((Object)oldTableId)) {
                    return new ColumnReference(toSetTableId, oldParam.getColumnId());
                }
                return oldParam;
            }
            if (param instanceof Expression) {
                Expression oldParam = (Expression)param;
                try {
                    TableReferenceReplacer replacer = new TableReferenceReplacer(oldParam);
                    return replacer.replaceTableId(oldTableId, toSetTableId).getExpression();
                }
                catch (MalformedExpressionException e) {
                    return oldParam;
                }
            }
            if (param instanceof Map) {
                try {
                    HashMap newComposite = new HashMap();
                    Map oldParam = (Map)param;
                    for (Map.Entry entry : oldParam.entrySet()) {
                        newComposite.put(entry.getKey(), InvocationCreator.updateParameterReferences(entry.getValue(), oldTableId, toSetTableId));
                    }
                    return newComposite;
                }
                catch (Throwable t) {
                    return param;
                }
            }
            if (param instanceof Iterable) {
                ArrayList<Object> newIterable = new ArrayList<Object>();
                for (Object child : (Iterable)param) {
                    newIterable.add(InvocationCreator.updateParameterReferences(child, oldTableId, toSetTableId));
                }
                return newIterable;
            }
        }
        return param;
    }
}

