/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.dbutils.DbUtils;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.gcube.data.analysis.tabulardata.operation.StatementContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryThread
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(QueryThread.class);
    private STATE state = STATE.PENDING;
    private SQLException error = null;
    private DatabaseConnectionProvider connectionProvider;
    private String query;

    protected QueryThread(DatabaseConnectionProvider connectionProvider, String query) {
        this.connectionProvider = connectionProvider;
        this.query = query;
    }

    @Override
    public void run() {
        block5: {
            this.state = STATE.STARTED;
            Connection conn = null;
            Statement stmt = null;
            try {
                try {
                    conn = this.connectionProvider.getConnection();
                    stmt = conn.createStatement();
                    StatementContainer.set(stmt);
                    stmt.execute(this.query);
                    this.state = STATE.FINISHED;
                }
                catch (SQLException e) {
                    this.state = STATE.STOPPED;
                    String msg = "Unable to execute SQL command: " + this.query;
                    log.error(msg, (Throwable)e);
                    this.error = e;
                    DbUtils.closeQuietly((Statement)stmt);
                    StatementContainer.reset();
                    DbUtils.closeQuietly((Connection)conn);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(stmt);
                StatementContainer.reset();
                DbUtils.closeQuietly((Connection)conn);
                throw throwable;
            }
            DbUtils.closeQuietly((Statement)stmt);
            StatementContainer.reset();
            DbUtils.closeQuietly((Connection)conn);
        }
    }

    public STATE getState() {
        return this.state;
    }

    public SQLException getError() {
        return this.error;
    }

    public static enum STATE {
        PENDING,
        STARTED,
        FINISHED,
        STOPPED;

    }
}

