package org.gcube.data.analysis.tabulardata.operation;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

import org.apache.commons.dbutils.DbUtils;
import org.gcube.data.analysis.tabulardata.cube.data.connection.DatabaseConnectionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryThread implements Runnable {

	private static Logger log = LoggerFactory.getLogger(QueryThread.class);
	
	public enum STATE {
		PENDING, STARTED, FINISHED, STOPPED
	}
		
	private STATE state = STATE.PENDING;
	
	private SQLException error = null;
	
	private DatabaseConnectionProvider connectionProvider;
	private String query;
	
	
	
	protected QueryThread(DatabaseConnectionProvider connectionProvider,
			String query) {
		super();
		this.connectionProvider = connectionProvider;
		this.query = query;
	}


	public void run() {
		this.state = STATE.STARTED;		
		Connection conn= null;
		Statement stmt = null;
		try {
			conn = connectionProvider.getConnection();
			stmt = conn.createStatement();
			stmt.execute(query);
			this.state = STATE.FINISHED;
		} catch (SQLException e) {
			this.state = STATE.STOPPED;
			String msg = "Unable to execute SQL command: " + query;
			log.error(msg, e);
			this.error = e;
		} finally {
			DbUtils.closeQuietly(stmt);
			DbUtils.closeQuietly(conn);
		}
		
	}
	
	public STATE getState() {
		return state;
	}

	public SQLException getError() {
		return error;
	}
	
	
	

}
