package org.gcube.data.analysis.tabulardata.operation.worker.results.resources;

import java.net.URI;
import java.util.Calendar;

public class ImmutableURIResult implements ResourceDescriptorResult {
	
	/**
	 * 
	 */
	private static final long serialVersionUID = -4754240010695558432L;

	private InternalURI uri;
	
	private ResourceScope resourceScope = ResourceScope.LOCAL;
	
	private String description;
	
	private Calendar creationDate;
		
	public ImmutableURIResult(URI uri, String description,
			Calendar creationDate) {
		super();
		this.uri = new InternalURI(uri);
		this.description = description;
		this.creationDate = creationDate;
	}
	
	public ImmutableURIResult(URI uri, String description,
			Calendar creationDate, ResourceScope resourceScope) {
		super();
		this.uri = new InternalURI(uri);
		this.description = description;
		this.creationDate = creationDate;
		this.resourceScope = resourceScope;
	}

	@Override
	public InternalURI getResource() {
		return uri;
	}

	@Override
	public String getDescription() {
		return description;
	}

	@Override
	public Calendar getCreationDate() {
		return creationDate;
	}
	
	
	@Override
	public ResourceScope getResourceScope() {
		return resourceScope;
	}

	@Override
	public String toString() {
		return "ImmutableResourceDescriptorResult [uri=" + uri
				+ ", description=" + description + ", creationDate="
				+ creationDate + "]";
	}
	
}
