package org.gcube.data.analysis.tabulardata.operation.worker.exceptions;

import org.gcube.data.analysis.tabulardata.operation.worker.Worker;

public class WorkerException extends Exception {

	private static final long serialVersionUID = 7992314300234460689L;
	
	private Worker fallbackWorker;

	public WorkerException(String message, Throwable cause, Worker fallbackWorker) {
		super(message, cause);
		this.fallbackWorker = fallbackWorker;
	}

	public WorkerException(String message, Worker fallbackWorker) {
		super(message);
		this.fallbackWorker = fallbackWorker;
	}

	public WorkerException(String message, Throwable cause) {
		super(message, cause);
	}

	public WorkerException(String message) {
		super(message);
	}

	public Worker getFallbackWorker() {
		return fallbackWorker;
	}

}
