/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.parameters;

public class Cardinality {
    public static Cardinality ONE = new Cardinality(1, 1);
    public static Cardinality OPTIONAL = new Cardinality(0, 1);
    private int minimum;
    private int maximum;

    private Cardinality() {
    }

    public Cardinality(int minimum, int maximum) {
        this.setMinimum(minimum);
        this.setMaximum(maximum);
    }

    public int getMinimum() {
        return this.minimum;
    }

    public void setMinimum(int minimum) {
        if (minimum < 0) {
            throw new IllegalArgumentException("Minimum cardinality must be equal or greater than 0.");
        }
        this.minimum = minimum;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public void setMaximum(int maximum) {
        if (maximum < 1) {
            throw new IllegalArgumentException("Maximum cardinality must be equal or greater than 1.");
        }
        this.maximum = maximum;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.maximum;
        result = 31 * result + this.minimum;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Cardinality other = (Cardinality)obj;
        if (this.maximum != other.maximum) {
            return false;
        }
        return this.minimum == other.minimum;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Cardinality [minimum=");
        builder.append(this.minimum);
        builder.append(", maximum=");
        builder.append(this.maximum);
        builder.append("]");
        return builder.toString();
    }
}

