/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.parameters.leaves;

import java.util.List;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.table.TableType;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;

public class TargetColumnParameter
extends LeafParameter<ColumnReference> {
    private List<TableType> allowedTableTypes = null;
    private List<ColumnType> allowedColumnTypes = null;

    private TargetColumnParameter() {
    }

    public TargetColumnParameter(String identifier, String name, String description, Cardinality cardinality, List<TableType> allowedTableTypes, List<ColumnType> allowedColumnTypes) {
        super(identifier, name, description, cardinality);
        this.allowedTableTypes = allowedTableTypes;
        this.allowedColumnTypes = allowedColumnTypes;
    }

    @Override
    public Class<ColumnReference> getParameterType() {
        return ColumnReference.class;
    }

    public List<TableType> getAllowedTableTypes() {
        return this.allowedTableTypes;
    }

    public List<ColumnType> getAllowedColumnTypes() {
        return this.allowedColumnTypes;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.allowedColumnTypes == null ? 0 : this.allowedColumnTypes.hashCode());
        result = 31 * result + (this.allowedTableTypes == null ? 0 : this.allowedTableTypes.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TargetColumnParameter other = (TargetColumnParameter)obj;
        if (this.allowedColumnTypes == null ? other.allowedColumnTypes != null : !this.allowedColumnTypes.equals(other.allowedColumnTypes)) {
            return false;
        }
        return !(this.allowedTableTypes == null ? other.allowedTableTypes != null : !this.allowedTableTypes.equals(other.allowedTableTypes));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TargetColumnParameter [getIdentifier()=");
        builder.append(this.getIdentifier());
        builder.append(", getName()=");
        builder.append(this.getName());
        builder.append(", getDescription()=");
        builder.append(this.getDescription());
        builder.append(", getCardinality()=");
        builder.append(this.getCardinality());
        builder.append(", getParameterType()=");
        builder.append(this.getParameterType());
        builder.append(", getAllowedTableTypes()=");
        builder.append(this.getAllowedTableTypes());
        builder.append(", getAllowedColumnTypes()=");
        builder.append(this.getAllowedColumnTypes());
        builder.append("]");
        return builder.toString();
    }
}

