package org.gcube.data.analysis.tabulardata.operation.worker;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;

@XmlAccessorType(XmlAccessType.FIELD)
public class OperationDescriptor {

	private OperationId operationId;

	private String name;

	private String description;

	private OperationScope scope;

	private OperationType type;

	@SuppressWarnings("unused")
	private OperationDescriptor() {
	}

	public OperationDescriptor(OperationId operationId, String name, String description, OperationScope scope,
			OperationType type) {
		this.operationId = operationId;
		this.name = name;
		this.description = description;
		this.scope = scope;
		this.type = type;
	}

	public OperationId getOperationId() {
		return operationId;
	}

	public String getName() {
		return name;
	}

	public String getDescription() {
		return description;
	}

	public OperationScope getScope() {
		return scope;
	}

	public OperationType getType() {
		return type;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("OperationDescriptor [\n\toperationId=");
		builder.append(operationId);
		builder.append(",\n\tname=");
		builder.append(name);
		builder.append(",\n\tdescription=");
		builder.append(description);
		builder.append(",\n\tscope=");
		builder.append(scope);
		builder.append(",\n\ttype=");
		builder.append(type);
		builder.append("\n]");
		return builder.toString();
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((description == null) ? 0 : description.hashCode());
		result = prime * result + ((name == null) ? 0 : name.hashCode());
		result = prime * result + ((operationId == null) ? 0 : operationId.hashCode());
		result = prime * result + ((scope == null) ? 0 : scope.hashCode());
		result = prime * result + ((type == null) ? 0 : type.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		OperationDescriptor other = (OperationDescriptor) obj;
		if (description == null) {
			if (other.description != null)
				return false;
		} else if (!description.equals(other.description))
			return false;
		if (name == null) {
			if (other.name != null)
				return false;
		} else if (!name.equals(other.name))
			return false;
		if (operationId == null) {
			if (other.operationId != null)
				return false;
		} else if (!operationId.equals(other.operationId))
			return false;
		if (scope != other.scope)
			return false;
		if (type != other.type)
			return false;
		return true;
	}

	public static class OperationId {

		private long value;

		@SuppressWarnings("unused")
		private OperationId() {
		}

		public OperationId(Class<? extends WorkerFactory> type) {
			value = type.getCanonicalName().hashCode();
		}

		public OperationId(long value) {
			this.value = value;
		}

		public long getValue() {
			return value;
		}

		public void setValue(long value) {
			this.value = value;
		}

		@Override
		public String toString() {
			StringBuilder builder = new StringBuilder();
			builder.append("OperationId [value=");
			builder.append(value);
			builder.append("]");
			return builder.toString();
		}

		@Override
		public int hashCode() {
			final int prime = 31;
			int result = 1;
			result = prime * result + (int) (value ^ (value >>> 32));
			return result;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			OperationId other = (OperationId) obj;
			if (value != other.value)
				return false;
			return true;
		}

	}

	public static enum OperationScope {

		VOID, TABLE, COLUMN, DATA

	}

	public static enum OperationType {

		TRANSFORMATION, VALIDATION, IMPORT, EXPORT

	}

}
