/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.worker;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.gcube.data.analysis.tabulardata.operation.worker.WorkerFactory;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class OperationDescriptor {
    private OperationId operationId;
    private String name;
    private String description;
    private OperationScope scope;
    private OperationType type;

    private OperationDescriptor() {
    }

    public OperationDescriptor(OperationId operationId, String name, String description, OperationScope scope, OperationType type) {
        this.operationId = operationId;
        this.name = name;
        this.description = description;
        this.scope = scope;
        this.type = type;
    }

    public OperationId getOperationId() {
        return this.operationId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public OperationScope getScope() {
        return this.scope;
    }

    public OperationType getType() {
        return this.type;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("OperationDescriptor [\n\toperationId=");
        builder.append(this.operationId);
        builder.append(",\n\tname=");
        builder.append(this.name);
        builder.append(",\n\tdescription=");
        builder.append(this.description);
        builder.append(",\n\tscope=");
        builder.append((Object)this.scope);
        builder.append(",\n\ttype=");
        builder.append((Object)this.type);
        builder.append("\n]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.operationId == null ? 0 : this.operationId.hashCode());
        result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OperationDescriptor other = (OperationDescriptor)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.operationId == null ? other.operationId != null : !this.operationId.equals(other.operationId)) {
            return false;
        }
        if (this.scope != other.scope) {
            return false;
        }
        return this.type == other.type;
    }

    public static enum OperationType {
        TRANSFORMATION,
        VALIDATION,
        IMPORT,
        EXPORT;

    }

    public static enum OperationScope {
        VOID,
        TABLE,
        COLUMN,
        DATA;

    }

    public static class OperationId {
        private long value;

        private OperationId() {
        }

        public OperationId(Class<? extends WorkerFactory> type) {
            this.value = type.getCanonicalName().hashCode();
        }

        public OperationId(long value) {
            this.value = value;
        }

        public long getValue() {
            return this.value;
        }

        public void setValue(long value) {
            this.value = value;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("OperationId [value=");
            builder.append(this.value);
            builder.append("]");
            return builder.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.value ^ this.value >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OperationId other = (OperationId)obj;
            return this.value == other.value;
        }
    }
}

