package org.gcube.data.analysis.tabulardata.operation.parameters.leaves;

import java.util.List;

import org.gcube.data.analysis.tabulardata.model.datatype.BooleanType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.DateType;
import org.gcube.data.analysis.tabulardata.model.datatype.GeometryType;
import org.gcube.data.analysis.tabulardata.model.datatype.IntegerType;
import org.gcube.data.analysis.tabulardata.model.datatype.NumericType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;

import com.google.common.collect.Lists;

public class DataTypeParameter extends LeafParameter<DataType> {

	public List<Class<? extends DataType>> allowedDataTypes;
	
	@SuppressWarnings("unused")
	private DataTypeParameter() {}

	public DataTypeParameter(String identifier, String name, String description, Cardinality cardinality,
			List<Class<? extends DataType>> allowedDataTypes) {
		super(identifier, name, description, cardinality);
		this.allowedDataTypes = allowedDataTypes;
	}

	public DataTypeParameter(String identifier, String name, String description, Cardinality cardinality) {
		super(identifier, name, description, cardinality);
		// TODO-LF Solution with classpath scanning
		allowedDataTypes = Lists.newArrayList();
		allowedDataTypes.add(BooleanType.class);
		allowedDataTypes.add(DateType.class);
		allowedDataTypes.add(IntegerType.class);
		allowedDataTypes.add(NumericType.class);
		allowedDataTypes.add(TextType.class);
		allowedDataTypes.add(GeometryType.class);
	}

	public List<Class<? extends DataType>> getAllowedDataTypes() {
		return allowedDataTypes;
	}

	@Override
	public Class<DataType> getParameterType() {
		return DataType.class;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = prime * result + ((allowedDataTypes == null) ? 0 : allowedDataTypes.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;
		DataTypeParameter other = (DataTypeParameter) obj;
		if (allowedDataTypes == null) {
			if (other.allowedDataTypes != null)
				return false;
		} else if (!allowedDataTypes.equals(other.allowedDataTypes))
			return false;
		return true;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("DataTypeParameter [getIdentifier()=");
		builder.append(getIdentifier());
		builder.append(", getName()=");
		builder.append(getName());
		builder.append(", getDescription()=");
		builder.append(getDescription());
		builder.append(", getCardinality()=");
		builder.append(getCardinality());
		builder.append(", getAllowedDataTypes()=");
		builder.append(getAllowedDataTypes());
		builder.append(", getParameterType()=");
		builder.append(getParameterType());
		builder.append("]");
		return builder.toString();
	}

}
