/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.worker;

import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.operation.parameters.Parameter;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationDescriptor;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class EligibleOperation {
    private OperationDescriptor operationDescriptor;
    private List<Parameter> parameters;
    private TableId targetTableId = null;
    private ColumnLocalId targetColumnId = null;

    private EligibleOperation() {
    }

    public EligibleOperation(OperationDescriptor operationDescriptor, List<Parameter> parameters) {
        this.operationDescriptor = operationDescriptor;
        this.parameters = parameters;
    }

    public EligibleOperation(OperationDescriptor operationDescriptor, List<Parameter> parameters, TableId targetTableId) {
        this.operationDescriptor = operationDescriptor;
        this.parameters = parameters;
        this.targetTableId = targetTableId;
    }

    public EligibleOperation(OperationDescriptor operationDescriptor, List<Parameter> parameters, TableId targetTableId, ColumnLocalId targetColumnId) {
        this.operationDescriptor = operationDescriptor;
        this.parameters = parameters;
        this.targetTableId = targetTableId;
        this.targetColumnId = targetColumnId;
    }

    public OperationDescriptor getOperationDescriptor() {
        return this.operationDescriptor;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public TableId getTargetTableId() {
        return this.targetTableId;
    }

    public ColumnLocalId getTargetColumnId() {
        return this.targetColumnId;
    }

    public OperationInvocation createOperationInvocation(Map<String, Object> parameterInstances) {
        return new OperationInvocation(this.targetTableId, this.targetColumnId, this.operationDescriptor, parameterInstances);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("EligibleOperation [operationDescriptor=");
        builder.append(this.operationDescriptor);
        builder.append(", parameters=");
        builder.append(this.parameters);
        builder.append(", targetTableId=");
        builder.append(this.targetTableId);
        builder.append(", targetColumnId=");
        builder.append(this.targetColumnId);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.operationDescriptor == null ? 0 : this.operationDescriptor.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : ((Object)this.parameters).hashCode());
        result = 31 * result + (this.targetColumnId == null ? 0 : this.targetColumnId.hashCode());
        result = 31 * result + (this.targetTableId == null ? 0 : this.targetTableId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EligibleOperation other = (EligibleOperation)obj;
        if (this.operationDescriptor == null ? other.operationDescriptor != null : !this.operationDescriptor.equals(other.operationDescriptor)) {
            return false;
        }
        if (this.parameters == null ? other.parameters != null : !((Object)this.parameters).equals(other.parameters)) {
            return false;
        }
        if (this.targetColumnId == null ? other.targetColumnId != null : !this.targetColumnId.equals((Object)other.targetColumnId)) {
            return false;
        }
        return !(this.targetTableId == null ? other.targetTableId != null : !this.targetTableId.equals((Object)other.targetTableId));
    }
}

