package org.gcube.data.analysis.tabulardata.expression.composite;

import java.util.List;

import org.gcube.data.analysis.tabulardata.expression.CompositeExpression;
import org.gcube.data.analysis.tabulardata.expression.Expression;

public abstract class MultipleArgsBoolCondition implements CompositeExpression {
	
	List<Expression> arguments;

	public MultipleArgsBoolCondition(List<Expression> arguments) {
		this.arguments = arguments;
		checkArgsNumber();
	}

	public void checkArgsNumber() {
		if (arguments.size()<=1) throw new RuntimeException("Invalid number of arguments: " + arguments.size() + ". At least 2 are needed.");
	}
	
	public List<Expression> getChilds(){
		return arguments;
	}

}