/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.cube;

import java.util.ArrayList;
import java.util.Collection;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.exceptions.NoSuchTableException;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableCreator;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableManager;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableMetaCreator;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableMetaCreatorProvider;
import org.gcube.data.analysis.tabulardata.cube.time.TimeCodelistCreator;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.metadata.column.DataValidationMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.column.ValidationReferencesMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ValidationsMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.GlobalDataValidationReportMetadata;
import org.gcube.data.analysis.tabulardata.model.metadata.table.TableMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.model.table.TableType;
import org.gcube.data.analysis.tabulardata.model.table.type.CodelistTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.DatasetTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.DatasetViewTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.GenericTableType;
import org.gcube.data.analysis.tabulardata.model.table.type.HierarchicalCodelistTableType;
import org.gcube.data.analysis.tabulardata.model.time.PeriodType;

@Singleton
@Default
public class DefaultCubeManager
implements CubeManager {
    private Provider<TableCreator> codelistCreatorProvider;
    private Provider<TableCreator> datasetCreatorProvider;
    private Provider<TableCreator> hclCreatorProvider;
    private Provider<TableCreator> unsafeTableCreatorProvider;
    private Provider<TableCreator> genericTableCreatorProvider;
    private Provider<TableCreator> viewTableCreatorProvider;
    private TableMetaCreatorProvider defaultTableMetaCreatorProvider;
    private TableManager tableManager;
    private TimeCodelistCreator timeCodelistCreator;

    @Inject
    private DefaultCubeManager(TableManager tableManager, @Named(value="Codelist") Instance<TableCreator> codelistCreatorProvider, @Named(value="Dataset") Instance<TableCreator> datasetCreatorProvider, @Named(value="HCL") Instance<TableCreator> hclCreatorProvider, @Named(value="ViewTable") Instance<TableCreator> tempTableCreatorProvider, @Named(value="GenericTable") Instance<TableCreator> genericTableCreatorProvider, @Named(value="ViewTable") Instance<TableCreator> viewTableCreatorProvider, TableMetaCreatorProvider tableMetaCreatorProvider, TimeCodelistCreator timeCreator) {
        this.tableManager = tableManager;
        this.codelistCreatorProvider = codelistCreatorProvider;
        this.datasetCreatorProvider = datasetCreatorProvider;
        this.hclCreatorProvider = hclCreatorProvider;
        this.unsafeTableCreatorProvider = tempTableCreatorProvider;
        this.genericTableCreatorProvider = genericTableCreatorProvider;
        this.viewTableCreatorProvider = viewTableCreatorProvider;
        this.defaultTableMetaCreatorProvider = tableMetaCreatorProvider;
        this.timeCodelistCreator = timeCreator;
    }

    public TableCreator createDataset() {
        return (TableCreator)this.datasetCreatorProvider.get();
    }

    public Collection<Table> getTables() {
        return this.tableManager.getAll();
    }

    public Collection<Table> getTables(TableType tableType) {
        return this.tableManager.getAll(tableType);
    }

    public Table getTable(TableId id) throws NoSuchTableException {
        return this.tableManager.get(id);
    }

    public TableCreator createTable(TableType type) {
        if (type.equals((Object)new CodelistTableType())) {
            return (TableCreator)this.codelistCreatorProvider.get();
        }
        if (type.equals((Object)new DatasetTableType())) {
            return (TableCreator)this.datasetCreatorProvider.get();
        }
        if (type.equals((Object)new GenericTableType())) {
            return (TableCreator)this.genericTableCreatorProvider.get();
        }
        if (type.equals((Object)new HierarchicalCodelistTableType())) {
            return (TableCreator)this.hclCreatorProvider.get();
        }
        if (type.equals((Object)new DatasetViewTableType())) {
            return (TableCreator)this.viewTableCreatorProvider.get();
        }
        throw new UnsupportedOperationException("Unsupported table type: " + type);
    }

    public void removeTable(TableId id) throws NoSuchTableException {
        this.tableManager.remove(id);
    }

    public TableMetaCreator modifyTableMeta(TableId tableId) throws NoSuchTableException {
        return this.defaultTableMetaCreatorProvider.get(tableId);
    }

    public Table getTimeTable(PeriodType periodType) {
        Table resultTable = this.timeCodelistCreator.getTable(periodType);
        return resultTable;
    }

    public Table removeValidations(TableId id) throws NoSuchTableException {
        Table table = this.tableManager.removeValidationColumns(id);
        for (Column column : table.getColumns()) {
            column.removeMetadata(ValidationReferencesMetadata.class);
            column.removeMetadata(DataValidationMetadata.class);
        }
        table.removeMetadata(ValidationsMetadata.class);
        table.removeMetadata(GlobalDataValidationReportMetadata.class);
        for (Column col : table.getColumns()) {
            col.removeMetadata(ValidationsMetadata.class);
        }
        this.tableManager.save(table, true);
        return table;
    }

    public Table addValidations(TableId id, ValidationsMetadata tableValidationMetadata, Column ... validationColumns) throws NoSuchTableException {
        Table table = this.tableManager.addValidationColumns(id, validationColumns);
        if (tableValidationMetadata != null) {
            if (!table.contains(ValidationsMetadata.class)) {
                ValidationsMetadata validationsMetadata = new ValidationsMetadata(new ArrayList());
                validationsMetadata.addAllValidations((Collection)tableValidationMetadata.getValidations());
                table.setMetadata((TableMetadata)validationsMetadata);
            } else {
                ValidationsMetadata metadata = (ValidationsMetadata)table.getMetadata(ValidationsMetadata.class);
                metadata.addAllValidations((Collection)tableValidationMetadata.getValidations());
            }
        }
        this.tableManager.save(table, true);
        return table;
    }

    public Table addValidations(TableId id, Column ... validationColumns) throws NoSuchTableException {
        return this.addValidations(id, (ValidationsMetadata)null, validationColumns);
    }

    public Table removeColumn(TableId id, ColumnLocalId localId) throws NoSuchTableException {
        Table table = this.tableManager.removeColumn(id, localId);
        this.tableManager.save(table, true);
        return table;
    }
}

