/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.cube.tablemanagers.hcl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gcube.data.analysis.tabulardata.cube.data.DatabaseWrangler;
import org.gcube.data.analysis.tabulardata.cube.metadata.CubeMetadataWrangler;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.DefaultTableCreator;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableManager;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.DimensionColumnType;
import org.gcube.data.analysis.tabulardata.model.table.TableType;
import org.gcube.data.analysis.tabulardata.model.table.type.HierarchicalCodelistTableType;

public class HCLCreator
extends DefaultTableCreator {
    private static List<ColumnType> indexedColumnTypes = new ArrayList<ColumnType>();

    static {
        indexedColumnTypes.add((ColumnType)new DimensionColumnType());
    }

    public HCLCreator(DatabaseWrangler dbWrangler, CubeMetadataWrangler cmWrangler, TableManager tableManager) {
        super(dbWrangler, cmWrangler, tableManager, (TableType)new HierarchicalCodelistTableType());
    }

    @Override
    protected void addIndexes(String tableName, Collection<Column> columns) {
        for (Column column : columns) {
            if (!indexedColumnTypes.contains(column.getColumnType())) continue;
            this.dbWrangler.createIndex(tableName, column.getName());
        }
    }
}

