/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.cube.tablemanagers;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.RandomStringUtils;
import org.gcube.data.analysis.tabulardata.cube.data.DatabaseWrangler;
import org.gcube.data.analysis.tabulardata.cube.exceptions.NoSuchTableException;
import org.gcube.data.analysis.tabulardata.cube.exceptions.TableCreationException;
import org.gcube.data.analysis.tabulardata.cube.metadata.CubeMetadataWrangler;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableCreator;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableManager;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.type.IdColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.IntegerType;
import org.gcube.data.analysis.tabulardata.model.idioms.ColumnHasName;
import org.gcube.data.analysis.tabulardata.model.metadata.table.TableMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultTableCreator
implements TableCreator {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    protected DatabaseWrangler dbWrangler;
    protected CubeMetadataWrangler mdWrangler;
    protected TableManager tableManager;
    protected List<Column> newColumns = Lists.newArrayList();
    protected Table tableToClone = null;
    protected Set<Column> columnsToRemove = Sets.newHashSet();
    protected boolean copyData = false;
    private TableType tableType;

    public DefaultTableCreator(DatabaseWrangler dbWrangler, CubeMetadataWrangler mdWrangler, TableManager tableManager, TableType tableType) {
        this.dbWrangler = dbWrangler;
        this.mdWrangler = mdWrangler;
        this.tableManager = tableManager;
        this.tableType = tableType;
    }

    public TableCreator addColumn(Column column) {
        this.checkColumnToAdd(column);
        this.newColumns.add(column);
        return this;
    }

    public TableCreator addColumns(Column ... columns) {
        for (Column column : columns) {
            this.addColumn(column);
        }
        return this;
    }

    private void checkColumnToAdd(Column column) {
        if (!this.isAllowedColumn(column)) {
            throw new IllegalArgumentException("Invalid column type: " + column.getColumnType());
        }
    }

    protected final boolean isAllowedColumn(Column column) {
        return !column.getColumnType().equals((Object)new IdColumnType());
    }

    public TableCreator like(Table table, boolean copyData) {
        return this.like(table, copyData, new ArrayList<Column>(0));
    }

    public TableCreator like(Table table, boolean copyData, List<Column> columnsToRemove) {
        this.tableToClone = table;
        this.copyData = copyData;
        this.removeColumns(columnsToRemove);
        return this;
    }

    private void removeColumns(List<Column> columnsToRemove) {
        if (this.tableToClone == null) {
            return;
        }
        this.columnsToRemove = Sets.newHashSet();
        for (Column columnToRemove : columnsToRemove) {
            this.removeColumn(columnToRemove);
        }
    }

    private void removeColumn(Column columnToRemove) {
        if (this.tableToClone.getColumns().contains(columnToRemove)) {
            this.columnsToRemove.add(columnToRemove);
        }
    }

    public Table create() throws TableCreationException {
        this.checkConsistency();
        this.setColumnNames();
        String tableName = null;
        if (this.tableToClone != null) {
            tableName = this.dbWrangler.cloneTable(this.tableToClone.getName(), this.copyData, false);
            for (Column column : this.columnsToRemove) {
                this.dbWrangler.removeColumn(tableName, column.getName());
            }
            for (Column column : this.newColumns) {
                this.dbWrangler.addColumn(tableName, column.getName(), column.getDataType());
            }
        } else {
            tableName = this.dbWrangler.createTable();
            for (Column column : this.newColumns) {
                this.dbWrangler.addColumn(tableName, column.getName(), column.getDataType());
            }
        }
        this.addIndexes(tableName, this.getAllColumnsExceptId());
        ArrayList columns = Lists.newArrayList((Object[])new Column[]{this.createIdColumn()});
        columns.addAll(this.getAllColumnsExceptId());
        Table newTable = this.createBaseTable(tableName, columns);
        if (this.tableToClone != null) {
            this.cloneMetadata(this.tableToClone, newTable);
        }
        return this.mdWrangler.save(newTable);
    }

    protected void checkConsistency() throws TableCreationException {
        try {
            this.checkColumnsRelationship();
        }
        catch (Exception e) {
            throw new TableCreationException(e.getMessage());
        }
    }

    private void checkColumnsRelationship() throws Exception {
        for (Column column : this.getAllColumnsExceptId()) {
            if (!column.hasRelationship()) continue;
            try {
                Table targetTable = this.tableManager.get(column.getRelationship().getTargetTableId());
                targetTable.getColumnById(column.getRelationship().getTargetColumnId());
            }
            catch (NoSuchTableException e) {
                throw new Exception(String.format("Referenced Codelist with ID %1$s does not exists.", column.getRelationship().getTargetTableId()));
            }
        }
    }

    protected void setColumnNames() {
        List<Column> columns = this.getAllColumnsExceptId();
        for (Column column : columns) {
            String eligibleName;
            if (column.hasName()) continue;
            while (!Collections2.filter(columns, (Predicate)new ColumnHasName(eligibleName = ColumnNameGenerator.generateColumnName())).isEmpty()) {
            }
            column.setName(eligibleName);
        }
    }

    protected Table createBaseTable(String tableName, List<Column> columns) {
        Table result = new Table(this.tableType);
        result.setColumns(columns);
        result.setName(tableName);
        return result;
    }

    protected void cloneMetadata(Table sourceTable, Table destTable) {
        for (TableMetadata m : sourceTable.getAllMetadata()) {
            if (!m.isInheritable()) continue;
            destTable.setMetadata(m);
        }
    }

    protected List<Column> getAllColumnsExceptId() {
        ArrayList result = Lists.newArrayList();
        if (this.tableToClone != null) {
            ArrayList clonedColumns = Lists.newArrayList((Iterable)this.tableToClone.getColumns());
            clonedColumns.removeAll(this.columnsToRemove);
            result.addAll(clonedColumns);
            result.removeAll(this.tableToClone.getColumnsByType((ColumnType)new IdColumnType()));
        }
        result.addAll(this.newColumns);
        return result;
    }

    protected abstract void addIndexes(String var1, Collection<Column> var2);

    protected Column createIdColumn() {
        Column idColumn = new Column((DataType)new IntegerType(), (ColumnType)new IdColumnType());
        idColumn.setName("id");
        return idColumn;
    }

    private static class ColumnNameGenerator {
        private ColumnNameGenerator() {
        }

        public static String generateColumnName() {
            return RandomStringUtils.random((int)6, (boolean)true, (boolean)false);
        }
    }
}

