/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.cube.tablemanagers;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gcube.data.analysis.tabulardata.cube.data.DatabaseWrangler;
import org.gcube.data.analysis.tabulardata.cube.exceptions.NoSuchTableException;
import org.gcube.data.analysis.tabulardata.cube.exceptions.TableCreationException;
import org.gcube.data.analysis.tabulardata.cube.metadata.CubeMetadataWrangler;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableCreator;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableManager;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.IdColumn;
import org.gcube.data.analysis.tabulardata.model.idioms.ColumnHasLabel;
import org.gcube.data.analysis.tabulardata.model.idioms.ColumnHasName;
import org.gcube.data.analysis.tabulardata.model.metadata.CubeMetadata;
import org.gcube.data.analysis.tabulardata.model.table.Table;

public abstract class DefaultTableCreator
implements TableCreator {
    protected DatabaseWrangler dbWrangler;
    protected CubeMetadataWrangler mdWrangler;
    protected TableManager tableManager;

    public DefaultTableCreator(DatabaseWrangler dbWrangler, CubeMetadataWrangler mdWrangler, TableManager tableManager) {
        this.dbWrangler = dbWrangler;
        this.mdWrangler = mdWrangler;
        this.tableManager = tableManager;
    }

    @Override
    public TableCreator addColumn(Column column) {
        return this.addColumns(column);
    }

    @Override
    public TableCreator addColumns(Column ... columns) {
        this.checkColumnsToAdd(columns);
        for (Column column : columns) {
            this.addNewColumn(column);
        }
        return this;
    }

    private void checkColumnsToAdd(Column ... columns) {
        for (Column column : columns) {
            if (this.isAllowedColumn(column)) continue;
            throw new IllegalArgumentException("Invalid column type: " + column.getColumnType());
        }
    }

    @Override
    public TableCreator like(Table table, boolean withData) {
        return this.like(table, withData, new ArrayList<Column>());
    }

    @Override
    public TableCreator like(Table table, boolean withData, Collection<Column> columnsToRemove) {
        if (!this.isAllowedCloneableTable(table)) {
            throw new IllegalArgumentException("Provided table to clone is not of the right type: " + table.getTableType());
        }
        if (this.getTableToClone() != null) {
            throw new IllegalStateException("A table to clone was already provided.");
        }
        for (Column column : columnsToRemove) {
            if (column.getColumnType() != ColumnType.ID) continue;
            throw new IllegalArgumentException("Cannot remove ID column");
        }
        for (Column column : columnsToRemove) {
            if (table.getColumns().contains(column)) continue;
            throw new IllegalArgumentException("The provided table does not contain the column to remove: " + column);
        }
        this.setTableToClone(table);
        this.setCloneWithData(withData);
        this.setColumnsToRemove(columnsToRemove);
        return this;
    }

    @Override
    public Table create() throws TableCreationException {
        this.checkConsistency();
        this.setColumnNames(this.getAllColumns());
        String tableName = null;
        if (this.getTableToClone() != null) {
            tableName = this.dbWrangler.cloneTable(this.getTableToClone().getName(), this.isCloneWithData(), false);
            for (Column column : this.getColumnsToRemove()) {
                this.dbWrangler.removeColumn(tableName, column.getName());
            }
            for (Column column : this.getNewColumns()) {
                this.dbWrangler.addColumn(tableName, column.getName(), column.getDataType());
            }
        } else {
            tableName = this.dbWrangler.createTable();
            for (Column column : this.getNewColumns()) {
                this.dbWrangler.addColumn(tableName, column.getName(), column.getDataType());
            }
        }
        this.addIndexes(tableName, this.getAllColumns());
        Collection<Column> columns = this.getAllColumns();
        columns.add((Column)new IdColumn());
        Table newTable = this.createBaseTable(tableName, columns);
        if (this.getTableToClone() != null) {
            newTable.setParentTableId(this.getTableToClone().getId());
            this.cloneMetadata(this.getTableToClone(), newTable);
        }
        return this.mdWrangler.save(newTable);
    }

    protected abstract void addIndexes(String var1, Collection<Column> var2);

    protected abstract Table createBaseTable(String var1, Collection<Column> var2);

    protected void checkDuplicateLabels(Collection<Column> columns) throws TableCreationException {
        ArrayList labels = Lists.newArrayList();
        for (Column c : columns) {
            if (labels.contains(c.getLabel())) {
                throw new TableCreationException("Two columns with the same label " + c.getLabel() + " were provided.");
            }
            labels.add(c.getLabel());
        }
    }

    protected void setColumnNames(Collection<Column> columns) {
        int i = 0;
        String eligibleName = "field" + i;
        for (Column column : columns) {
            if (column.hasName()) continue;
            while (!Collections2.filter(columns, (Predicate)new ColumnHasName(eligibleName)).isEmpty()) {
                eligibleName = "field" + ++i;
            }
            column.setName(eligibleName);
        }
    }

    protected boolean isLabelPresent(String label, List<Column> columns) {
        Collection sameLabelColumns = Collections2.filter(columns, (Predicate)new ColumnHasLabel(label));
        return !sameLabelColumns.isEmpty();
    }

    protected void checkColumnsRelationship(Collection<Column> columns) throws Exception {
        for (Column column : columns) {
            if (!column.hasRelationship()) continue;
            try {
                this.tableManager.get(column.getRelationship().getTargetTableRef().getTableId());
            }
            catch (NoSuchTableException e) {
                throw new Exception(String.format("Referenced Codelist with ID %1$s does not exists.", column.getRelationship().getTargetTableRef().getTableId()));
            }
        }
    }

    protected void cloneMetadata(Table sourceTable, Table destTable) {
        for (CubeMetadata m : sourceTable.getAllMetadata()) {
            if (!m.isInheritable()) continue;
            destTable.setMetadata(m);
        }
    }

    protected abstract void checkConsistency() throws TableCreationException;

    protected abstract boolean isAllowedColumn(Column var1);

    protected abstract Collection<Column> getAllColumns();

    protected abstract Collection<Column> getNewColumns();

    protected abstract void addNewColumn(Column var1);

    protected abstract boolean isAllowedCloneableTable(Table var1);

    protected abstract Table getTableToClone();

    protected abstract void setTableToClone(Table var1);

    protected abstract boolean isCloneWithData();

    protected abstract void setCloneWithData(boolean var1);

    protected abstract Collection<Column> getColumnsToRemove();

    protected abstract void setColumnsToRemove(Collection<Column> var1);
}

