/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.cube;

import java.util.Collection;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.gcube.data.analysis.tabulardata.cube.CubeManager;
import org.gcube.data.analysis.tabulardata.cube.exceptions.CubeManagerException;
import org.gcube.data.analysis.tabulardata.cube.exceptions.NoSuchTableException;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableCreator;
import org.gcube.data.analysis.tabulardata.cube.tablemanagers.TableManager;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Default
public class DefaultCubeManager
implements CubeManager {
    static Logger log = LoggerFactory.getLogger(DefaultCubeManager.class);
    private Provider<TableCreator> codelistCreatorProvider;
    private Provider<TableCreator> datasetCreatorProvider;
    private Provider<TableCreator> hclCreatorProvider;
    private Provider<TableCreator> unsafeTableCreatorProvider;
    private Provider<TableCreator> genericTableCreatorProvider;
    private TableManager tableManager;

    @Inject
    private DefaultCubeManager(TableManager tableManager, @Named(value="Codelist") Instance<TableCreator> codelistCreatorProvider, @Named(value="Dataset") Instance<TableCreator> datasetCreatorProvider, @Named(value="HCL") Instance<TableCreator> hclCreatorProvider, @Named(value="ViewTable") Instance<TableCreator> tempTableCreatorProvider, @Named(value="GenericTable") Instance<TableCreator> genericTableCreatorProvider) {
        this.tableManager = tableManager;
        this.codelistCreatorProvider = codelistCreatorProvider;
        this.datasetCreatorProvider = datasetCreatorProvider;
        this.hclCreatorProvider = hclCreatorProvider;
        this.unsafeTableCreatorProvider = tempTableCreatorProvider;
        this.genericTableCreatorProvider = genericTableCreatorProvider;
    }

    public TableCreator createDataset() {
        return (TableCreator)this.datasetCreatorProvider.get();
    }

    @Override
    public Collection<Table> getTables() {
        return this.tableManager.getAll();
    }

    @Override
    public Collection<Table> getTables(TableType tableType) {
        return this.tableManager.getAll(tableType);
    }

    @Override
    public Table getTable(long id) throws NoSuchTableException {
        return this.tableManager.get(id);
    }

    @Override
    public void removeTable(long id) throws NoSuchTableException {
        this.tableManager.remove(id);
    }

    @Override
    public TableCreator createTable(TableType type) {
        switch (type) {
            case CODELIST: {
                return (TableCreator)this.codelistCreatorProvider.get();
            }
            case DATASET: {
                return (TableCreator)this.datasetCreatorProvider.get();
            }
            case GENERICTABLE: {
                return (TableCreator)this.genericTableCreatorProvider.get();
            }
            case HIERARCHICALCODELIST: {
                return (TableCreator)this.hclCreatorProvider.get();
            }
            case VIEWTABLE: {
                return (TableCreator)this.unsafeTableCreatorProvider.get();
            }
        }
        throw new RuntimeException("Unsupported table type: " + type);
    }

    @Override
    public void updateMetadata(Table table) throws CubeManagerException {
        this.tableManager.updateMetadata(table);
    }

    @Override
    public void removeTableWithMetdata(long id) throws NoSuchTableException {
        this.tableManager.removeRaw(id);
    }
}

