package org.gcube.data.analysis.tabulardata.cube.tablemanagers;

import java.util.Collection;

import javax.enterprise.inject.Default;
import javax.inject.Inject;

import org.gcube.data.analysis.tabulardata.cube.data.DatabaseWrangler;
import org.gcube.data.analysis.tabulardata.cube.exceptions.CubeManagerException;
import org.gcube.data.analysis.tabulardata.cube.exceptions.NoSuchTableException;
import org.gcube.data.analysis.tabulardata.cube.metadata.CubeMetadataWrangler;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableType;

@Default
public class TableManagerImpl implements TableManager {

	private DatabaseWrangler dbWrangler;

	private CubeMetadataWrangler cmWrangler;

	@Inject
	public TableManagerImpl(DatabaseWrangler dbWrangler, CubeMetadataWrangler cmWrangler) {
		this.dbWrangler = dbWrangler;
		this.cmWrangler = cmWrangler;
	}

	@Override
	public Collection<Table> getAll() {
		return cmWrangler.getAll();
	}

	@Override
	public Collection<Table> getAll(TableType tableType) {
		return cmWrangler.getAll(tableType);
	}

	@Override
	public Table get(long id) throws NoSuchTableException {
		try {
			return cmWrangler.get(id);
		} catch (org.gcube.data.analysis.tabulardata.cube.metadata.exceptions.NoSuchTableException e) {
			throw new NoSuchTableException(e.getId());
		}
	}

	@Override
	public void remove(long id) throws NoSuchTableException {
		Table table = get(id);
		dbWrangler.removeTable(table.getName());
		table.setExists(false);
		cmWrangler.update(table);
	}

	@Override
	public void updateMetadata(Table table) throws CubeManagerException {
		Table t = get(table.getId());
		if (!table.sameStructureAs(t))
			throw new CubeManagerException("Provided table does not have the same structure of registered table.");
		cmWrangler.update(table);
	}

	@Override
	public void removeRaw(long id) throws NoSuchTableException {
		Table table = get(id);
		dbWrangler.removeTable(table.getName());
		removeTableMetadata(table.getId());
	}
	
	private void removeTableMetadata(long id) throws NoSuchTableException{
		try {
			cmWrangler.remove(id);
		} catch (org.gcube.data.analysis.tabulardata.cube.metadata.exceptions.NoSuchTableException e) {
			throw new NoSuchTableException(id);
		}
	}

}
