/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.cube.metadata;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.gcube.data.analysis.tabulardata.cube.metadata.CubeMetadataWrangler;
import org.gcube.data.analysis.tabulardata.cube.metadata.exceptions.NoSuchTableException;
import org.gcube.data.analysis.tabulardata.cube.metadata.model.JPATable;
import org.gcube.data.analysis.tabulardata.cube.metadata.model.TableFactory;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.TableType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Default
@Singleton
public class JPAMetadataWrangler
implements CubeMetadataWrangler {
    Logger log = LoggerFactory.getLogger(JPAMetadataWrangler.class);
    EntityManager em;

    @Inject
    public JPAMetadataWrangler(EntityManager em) {
        this.em = em;
    }

    @Override
    public Table update(Table table) {
        JPATable jpaTable = new JPATable(table);
        this.mergeEntity(jpaTable);
        return TableFactory.createModelTable(jpaTable);
    }

    @Override
    public Table save(Table table) {
        JPATable jpaTable = new JPATable(table);
        this.persistEntity(jpaTable);
        return TableFactory.createModelTable(jpaTable);
    }

    @Override
    public Table get(long id) throws NoSuchTableException {
        TypedQuery query = this.getEntityManager().createNamedQuery("Table.findById", JPATable.class);
        query.setParameter("Id", (Object)id);
        List queryResult = query.getResultList();
        if (queryResult.size() > 0) {
            return TableFactory.createModelTable((JPATable)queryResult.get(0));
        }
        throw new NoSuchTableException(id);
    }

    @Override
    public List<Table> getAll() {
        ArrayList tables = Lists.newArrayList();
        TypedQuery query = this.getEntityManager().createNamedQuery("Table.findAll", JPATable.class);
        for (JPATable jpaTable : query.getResultList()) {
            tables.add(TableFactory.createModelTable(jpaTable));
        }
        return tables;
    }

    @Override
    public List<Table> getAll(TableType tableType) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Table.findAllByType", JPATable.class);
        query.setParameter("TableType", (Object)tableType);
        ArrayList tables = Lists.newArrayList();
        for (JPATable jpaTable : query.getResultList()) {
            tables.add(TableFactory.createModelTable(jpaTable));
        }
        return tables;
    }

    @Override
    public void remove(long id) throws NoSuchTableException {
        this.removeEntity(this.get(id));
    }

    private void persistEntity(Object entity) {
        this.getEntityManager().getTransaction().begin();
        this.getEntityManager().persist(entity);
        this.getEntityManager().getTransaction().commit();
        this.log.debug("Saved entity: " + entity);
    }

    private void mergeEntity(Object entity) {
        this.log.debug("Updating entity: " + entity);
        this.getEntityManager().getTransaction().begin();
        this.getEntityManager().merge(entity);
        this.getEntityManager().getTransaction().commit();
        this.log.debug("Updated entity: " + entity);
    }

    private void removeEntity(Object entity) {
        this.getEntityManager().getTransaction().begin();
        this.getEntityManager().remove(entity);
        this.getEntityManager().getTransaction().commit();
    }

    private EntityManager getEntityManager() {
        return this.em;
    }
}

