/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.cube.metadata.model;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.gcube.data.analysis.tabulardata.cube.metadata.model.JPAColumn;
import org.gcube.data.analysis.tabulardata.cube.metadata.model.JPATable;
import org.gcube.data.analysis.tabulardata.model.column.AttributeColumn;
import org.gcube.data.analysis.tabulardata.model.column.CodeColumn;
import org.gcube.data.analysis.tabulardata.model.column.CodelistRefColumn;
import org.gcube.data.analysis.tabulardata.model.column.Column;
import org.gcube.data.analysis.tabulardata.model.column.ColumnType;
import org.gcube.data.analysis.tabulardata.model.column.IdColumn;
import org.gcube.data.analysis.tabulardata.model.column.MeasureColumn;
import org.gcube.data.analysis.tabulardata.model.column.SystemColumn;
import org.gcube.data.analysis.tabulardata.model.table.Codelist;
import org.gcube.data.analysis.tabulardata.model.table.Dataset;
import org.gcube.data.analysis.tabulardata.model.table.GenericTable;
import org.gcube.data.analysis.tabulardata.model.table.HierarchicalCodelist;
import org.gcube.data.analysis.tabulardata.model.table.Table;
import org.gcube.data.analysis.tabulardata.model.table.ViewTable;

public class TableFactory {
    public static Table createModelTable(JPATable table) {
        Codelist t = null;
        Collection<Column> columns = ColumnFactory.createColumns(table.getColumns());
        switch (table.getTableType()) {
            case CODELIST: {
                t = new Codelist(table.getId(), table.getName(), columns);
                break;
            }
            case DATASET: {
                t = new Dataset(table.getId(), table.getName(), columns);
                break;
            }
            case HIERARCHICALCODELIST: {
                t = new HierarchicalCodelist(table.getId(), table.getName(), columns);
                break;
            }
            case VIEWTABLE: {
                t = new ViewTable(table.getId(), table.getName(), columns);
                break;
            }
            case GENERICTABLE: {
                t = new GenericTable(table.getId(), table.getName(), columns);
                break;
            }
            default: {
                throw new RuntimeException("Table type not supported: " + table.getTableType());
            }
        }
        t.setMetadata(table.getMetadata());
        t.setExists(table.exists());
        t.setParentTableId(table.getParentTableId());
        return t;
    }

    private static class ColumnFactory {
        private ColumnFactory() {
        }

        private static Column createColumn(JPAColumn column) {
            IdColumn result = null;
            switch (column.getType()) {
                case ATTRIBUTE: {
                    result = new AttributeColumn(column.getLabel(), column.getName(), column.getDataType());
                    break;
                }
                case CODE: {
                    result = new CodeColumn(column.getLabel(), column.getName());
                    break;
                }
                case CODELISTREF: {
                    result = new CodelistRefColumn(column.getLabel(), column.getName(), column.getRelationship());
                    break;
                }
                case ID: {
                    result = new IdColumn();
                    break;
                }
                case MEASURE: {
                    result = new MeasureColumn(column.getLabel(), column.getName(), column.getDataType());
                    break;
                }
                case SYSTEM: {
                    result = new SystemColumn(column.getLabel(), column.getName(), column.getDataType());
                    break;
                }
                default: {
                    throw new RuntimeException("Column type not supported: " + column.getType());
                }
            }
            result.setMetadata(column.getMetadata());
            return result;
        }

        public static Collection<Column> createColumns(Collection<JPAColumn> columns) {
            ArrayList result = Lists.newArrayList();
            for (JPAColumn jpaColumn : columns) {
                Column newcolumn = ColumnFactory.createColumn(jpaColumn);
                if (newcolumn.getColumnType() == ColumnType.ID) {
                    // empty if block
                }
                result.add(newcolumn);
            }
            return result;
        }
    }
}

